@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The frequency of the recurrence.
 */
public enum class RecurrenceFrequency(
    public val javaValue: com.pulumi.azurenative.labservices.enums.RecurrenceFrequency,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.enums.RecurrenceFrequency> {
    /**
     * Schedule will run every days.
     */
    Daily(com.pulumi.azurenative.labservices.enums.RecurrenceFrequency.Daily),

    /**
     * Schedule will run every week on days specified in weekDays.
     */
    Weekly(com.pulumi.azurenative.labservices.enums.RecurrenceFrequency.Weekly),
    ;

    override fun toJava(): com.pulumi.azurenative.labservices.enums.RecurrenceFrequency = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.enums.RecurrenceFrequency): RecurrenceFrequency = RecurrenceFrequency.values().first { it.javaValue == javaType }
    }
}
