@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether a VM will get shutdown when it has idled for a period of time.
 */
public enum class ShutdownOnIdleMode(
    public val javaValue: com.pulumi.azurenative.labservices.enums.ShutdownOnIdleMode,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.enums.ShutdownOnIdleMode> {
    /**
     * The VM won't be shut down when it is idle.
     */
    None(com.pulumi.azurenative.labservices.enums.ShutdownOnIdleMode.None),

    /**
     * The VM will be considered as idle when there is no keyboard or mouse input.
     */
    UserAbsence(com.pulumi.azurenative.labservices.enums.ShutdownOnIdleMode.UserAbsence),

    /**
     * The VM will be considered as idle when user is absent and the resource (CPU and disk) consumption is low.
     */
    LowUsage(com.pulumi.azurenative.labservices.enums.ShutdownOnIdleMode.LowUsage),
    ;

    override fun toJava(): com.pulumi.azurenative.labservices.enums.ShutdownOnIdleMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.enums.ShutdownOnIdleMode): ShutdownOnIdleMode = ShutdownOnIdleMode.values().first { it.javaValue == javaType }
    }
}
