@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.ImageReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Image reference information. Used in the virtual machine profile.
 * @property id Image resource ID
 * @property offer The image offer if applicable.
 * @property publisher The image publisher
 * @property sku The image SKU
 * @property version The image version specified on creation.
 */
public data class ImageReferenceArgs(
    public val id: Output<String>? = null,
    public val offer: Output<String>? = null,
    public val publisher: Output<String>? = null,
    public val sku: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.ImageReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.ImageReferenceArgs =
        com.pulumi.azurenative.labservices.inputs.ImageReferenceArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .offer(offer?.applyValue({ args0 -> args0 }))
            .publisher(publisher?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageReferenceArgs].
 */
@PulumiTagMarker
public class ImageReferenceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var offer: Output<String>? = null

    private var publisher: Output<String>? = null

    private var sku: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Image resource ID
     */
    @JvmName("xbferukmthqfnmnc")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The image offer if applicable.
     */
    @JvmName("igiwsltaacwovmfw")
    public suspend fun offer(`value`: Output<String>) {
        this.offer = value
    }

    /**
     * @param value The image publisher
     */
    @JvmName("pwmufouybhueghxt")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value The image SKU
     */
    @JvmName("fquuwhuhhufbyeiy")
    public suspend fun sku(`value`: Output<String>) {
        this.sku = value
    }

    /**
     * @param value The image version specified on creation.
     */
    @JvmName("admphccxlqqwtmxe")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Image resource ID
     */
    @JvmName("kkpcyjkjynvmbyqu")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The image offer if applicable.
     */
    @JvmName("uweynrfpqbpjiwpu")
    public suspend fun offer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offer = mapped
    }

    /**
     * @param value The image publisher
     */
    @JvmName("swfkjwjxrtefseju")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value The image SKU
     */
    @JvmName("hdeqjpdalpeerqim")
    public suspend fun sku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value The image version specified on creation.
     */
    @JvmName("yaolgyafmoknrcfr")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ImageReferenceArgs = ImageReferenceArgs(
        id = id,
        offer = offer,
        publisher = publisher,
        sku = sku,
        version = version,
    )
}
