@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.ReferenceVmArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Details of a Reference Vm
 * @property password The password of the virtual machine. This will be set to null in GET resource API
 * @property userName The username of the virtual machine
 */
public data class ReferenceVmArgs(
    public val password: Output<String>? = null,
    public val userName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.ReferenceVmArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.ReferenceVmArgs =
        com.pulumi.azurenative.labservices.inputs.ReferenceVmArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .userName(userName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReferenceVmArgs].
 */
@PulumiTagMarker
public class ReferenceVmArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The password of the virtual machine. This will be set to null in GET resource API
     */
    @JvmName("eqiniynrgjhmdaha")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The username of the virtual machine
     */
    @JvmName("uahepygqvgxvrbwg")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The password of the virtual machine. This will be set to null in GET resource API
     */
    @JvmName("mqhhhswnaltqrsui")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The username of the virtual machine
     */
    @JvmName("dpbjcfaqvcxmfjph")
    public suspend fun userName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): ReferenceVmArgs = ReferenceVmArgs(
        password = password,
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
