@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.SupportInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Support contact information and instructions.
 * @property email Support contact email address.
 * @property instructions Support instructions.
 * @property phone Support contact phone number.
 * @property url Support web address.
 */
public data class SupportInfoArgs(
    public val email: Output<String>? = null,
    public val instructions: Output<String>? = null,
    public val phone: Output<String>? = null,
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.SupportInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.SupportInfoArgs =
        com.pulumi.azurenative.labservices.inputs.SupportInfoArgs.builder()
            .email(email?.applyValue({ args0 -> args0 }))
            .instructions(instructions?.applyValue({ args0 -> args0 }))
            .phone(phone?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SupportInfoArgs].
 */
@PulumiTagMarker
public class SupportInfoArgsBuilder internal constructor() {
    private var email: Output<String>? = null

    private var instructions: Output<String>? = null

    private var phone: Output<String>? = null

    private var url: Output<String>? = null

    /**
     * @param value Support contact email address.
     */
    @JvmName("mihhsoqphyoertar")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value Support instructions.
     */
    @JvmName("gpqvidlnurkqifjp")
    public suspend fun instructions(`value`: Output<String>) {
        this.instructions = value
    }

    /**
     * @param value Support contact phone number.
     */
    @JvmName("fenemiosyhvmwuyi")
    public suspend fun phone(`value`: Output<String>) {
        this.phone = value
    }

    /**
     * @param value Support web address.
     */
    @JvmName("fjxcyguooskyfxal")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Support contact email address.
     */
    @JvmName("siisjnndidgynnij")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value Support instructions.
     */
    @JvmName("khanqqvafmigbsnm")
    public suspend fun instructions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instructions = mapped
    }

    /**
     * @param value Support contact phone number.
     */
    @JvmName("akrfxnlixpfgvtmo")
    public suspend fun phone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phone = mapped
    }

    /**
     * @param value Support web address.
     */
    @JvmName("yhsokjjsveghkqdm")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): SupportInfoArgs = SupportInfoArgs(
        email = email,
        instructions = instructions,
        phone = phone,
        url = url,
    )
}
