@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Connection profile for how users connect to lab virtual machines.
 * @property clientRdpAccess The enabled access level for Client Access over RDP.
 * @property clientSshAccess The enabled access level for Client Access over SSH.
 * @property webRdpAccess The enabled access level for Web Access over RDP.
 * @property webSshAccess The enabled access level for Web Access over SSH.
 */
public data class ConnectionProfileResponse(
    public val clientRdpAccess: String? = null,
    public val clientSshAccess: String? = null,
    public val webRdpAccess: String? = null,
    public val webSshAccess: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.ConnectionProfileResponse): ConnectionProfileResponse = ConnectionProfileResponse(
            clientRdpAccess = javaType.clientRdpAccess().map({ args0 -> args0 }).orElse(null),
            clientSshAccess = javaType.clientSshAccess().map({ args0 -> args0 }).orElse(null),
            webRdpAccess = javaType.webRdpAccess().map({ args0 -> args0 }).orElse(null),
            webSshAccess = javaType.webSshAccess().map({ args0 -> args0 }).orElse(null),
        )
    }
}
