@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * This represents the details about a User's environment and its state.
 * @property description Description of the Environment
 * @property environmentState Publishing state of the environment setting Possible values are Creating, Created, Failed
 * @property id Resource Id of the environment
 * @property latestOperationResult The details of the latest operation. ex: status, error
 * @property name Name of the Environment
 * @property passwordLastReset When the password was last reset on the environment.
 * @property provisioningState The provisioning state of the environment. This also includes LabIsFull and NotYetProvisioned status.
 * @property totalUsage How long the environment has been used by a lab user
 * @property virtualMachineDetails Details of backing DTL virtual machine with compute and network details.
 */
public data class EnvironmentDetailsResponse(
    public val description: String,
    public val environmentState: String,
    public val id: String,
    public val latestOperationResult: LatestOperationResultResponse,
    public val name: String,
    public val passwordLastReset: String,
    public val provisioningState: String,
    public val totalUsage: String,
    public val virtualMachineDetails: VirtualMachineDetailsResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.EnvironmentDetailsResponse): EnvironmentDetailsResponse = EnvironmentDetailsResponse(
            description = javaType.description(),
            environmentState = javaType.environmentState(),
            id = javaType.id(),
            latestOperationResult = javaType.latestOperationResult().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.LatestOperationResultResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            passwordLastReset = javaType.passwordLastReset(),
            provisioningState = javaType.provisioningState(),
            totalUsage = javaType.totalUsage(),
            virtualMachineDetails = javaType.virtualMachineDetails().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.VirtualMachineDetailsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
