@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents an environment instance
 * @property claimedByUserName The name or email address of the user who has claimed the environment
 * @property claimedByUserObjectId The AAD object Id of the user who has claimed the environment
 * @property claimedByUserPrincipalId The user principal Id of the user who has claimed the environment
 * @property id The identifier of the resource.
 * @property isClaimed Is the environment claimed or not
 * @property lastKnownPowerState Last known power state of the environment
 * @property latestOperationResult The details of the latest operation. ex: status, error
 * @property location The location of the resource.
 * @property name The name of the resource.
 * @property networkInterface Network details of the environment
 * @property passwordLastReset When the password was last reset on the environment.
 * @property provisioningState The provisioning status of the resource.
 * @property resourceSets The set of a VM and the setting id it was created for
 * @property tags The tags of the resource.
 * @property totalUsage How long the environment has been used by a lab user
 * @property type The type of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 */
public data class GetEnvironmentResult(
    public val claimedByUserName: String,
    public val claimedByUserObjectId: String,
    public val claimedByUserPrincipalId: String,
    public val id: String,
    public val isClaimed: Boolean,
    public val lastKnownPowerState: String,
    public val latestOperationResult: LatestOperationResultResponse,
    public val location: String? = null,
    public val name: String,
    public val networkInterface: NetworkInterfaceResponse,
    public val passwordLastReset: String,
    public val provisioningState: String? = null,
    public val resourceSets: ResourceSetResponse? = null,
    public val tags: Map<String, String>? = null,
    public val totalUsage: String,
    public val type: String,
    public val uniqueIdentifier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.GetEnvironmentResult): GetEnvironmentResult = GetEnvironmentResult(
            claimedByUserName = javaType.claimedByUserName(),
            claimedByUserObjectId = javaType.claimedByUserObjectId(),
            claimedByUserPrincipalId = javaType.claimedByUserPrincipalId(),
            id = javaType.id(),
            isClaimed = javaType.isClaimed(),
            lastKnownPowerState = javaType.lastKnownPowerState(),
            latestOperationResult = javaType.latestOperationResult().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.LatestOperationResultResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            networkInterface = javaType.networkInterface().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.NetworkInterfaceResponse.Companion.toKotlin(args0)
            }),
            passwordLastReset = javaType.passwordLastReset(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            resourceSets = javaType.resourceSets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.labservices.kotlin.outputs.ResourceSetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            totalUsage = javaType.totalUsage(),
            type = javaType.type(),
            uniqueIdentifier = javaType.uniqueIdentifier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
