@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents settings of an environment, from which environment instances would be created
 * @property configurationState Describes the user's progress in configuring their environment setting
 * @property description Describes the environment and its resource settings
 * @property id The identifier of the resource.
 * @property lastChanged Time when the template VM was last changed.
 * @property lastPublished Time when the template VM was last sent for publishing.
 * @property latestOperationResult The details of the latest operation. ex: status, error
 * @property location The location of the resource.
 * @property name The name of the resource.
 * @property provisioningState The provisioning status of the resource.
 * @property publishingState Describes the readiness of this environment setting
 * @property resourceSettings The resource specific settings
 * @property tags The tags of the resource.
 * @property title Brief title describing the environment and its resource settings
 * @property type The type of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 */
public data class GetEnvironmentSettingResult(
    public val configurationState: String? = null,
    public val description: String? = null,
    public val id: String,
    public val lastChanged: String,
    public val lastPublished: String,
    public val latestOperationResult: LatestOperationResultResponse,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String? = null,
    public val publishingState: String,
    public val resourceSettings: ResourceSettingsResponse,
    public val tags: Map<String, String>? = null,
    public val title: String? = null,
    public val type: String,
    public val uniqueIdentifier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.GetEnvironmentSettingResult): GetEnvironmentSettingResult = GetEnvironmentSettingResult(
            configurationState = javaType.configurationState().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastChanged = javaType.lastChanged(),
            lastPublished = javaType.lastPublished(),
            latestOperationResult = javaType.latestOperationResult().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.LatestOperationResultResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            publishingState = javaType.publishingState(),
            resourceSettings = javaType.resourceSettings().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.ResourceSettingsResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            uniqueIdentifier = javaType.uniqueIdentifier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
