@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents an image from the Azure Marketplace
 * @property author The author of the gallery image.
 * @property createdDate The creation date of the gallery image.
 * @property description The description of the gallery image.
 * @property icon The icon of the gallery image.
 * @property id The identifier of the resource.
 * @property imageReference The image reference of the gallery image.
 * @property isEnabled Indicates whether this gallery image is enabled.
 * @property isOverride Indicates whether this gallery has been overridden for this lab account
 * @property isPlanAuthorized Indicates if the plan has been authorized for programmatic deployment.
 * @property latestOperationResult The details of the latest operation. ex: status, error
 * @property location The location of the resource.
 * @property name The name of the resource.
 * @property planId The third party plan that applies to this image
 * @property provisioningState The provisioning status of the resource.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 */
public data class GetGalleryImageResult(
    public val author: String,
    public val createdDate: String,
    public val description: String,
    public val icon: String,
    public val id: String,
    public val imageReference: GalleryImageReferenceResponse,
    public val isEnabled: Boolean? = null,
    public val isOverride: Boolean? = null,
    public val isPlanAuthorized: Boolean? = null,
    public val latestOperationResult: LatestOperationResultResponse,
    public val location: String? = null,
    public val name: String,
    public val planId: String,
    public val provisioningState: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uniqueIdentifier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.GetGalleryImageResult): GetGalleryImageResult = GetGalleryImageResult(
            author = javaType.author(),
            createdDate = javaType.createdDate(),
            description = javaType.description(),
            icon = javaType.icon(),
            id = javaType.id(),
            imageReference = javaType.imageReference().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.GalleryImageReferenceResponse.Companion.toKotlin(args0)
            }),
            isEnabled = javaType.isEnabled().map({ args0 -> args0 }).orElse(null),
            isOverride = javaType.isOverride().map({ args0 -> args0 }).orElse(null),
            isPlanAuthorized = javaType.isPlanAuthorized().map({ args0 -> args0 }).orElse(null),
            latestOperationResult = javaType.latestOperationResult().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.LatestOperationResultResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            planId = javaType.planId(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uniqueIdentifier = javaType.uniqueIdentifier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
