@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents the PersonalPreferences for the user
 * @property favoriteLabResourceIds Array of favorite lab resource ids
 * @property id Id to be used by the cache orchestrator
 */
public data class GetGlobalUserPersonalPreferencesResult(
    public val favoriteLabResourceIds: List<String>? = null,
    public val id: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.GetGlobalUserPersonalPreferencesResult): GetGlobalUserPersonalPreferencesResult = GetGlobalUserPersonalPreferencesResult(
            favoriteLabResourceIds = javaType.favoriteLabResourceIds().map({ args0 -> args0 }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
        )
    }
}
