@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The lab resource.
 * @property autoShutdownProfile The resource auto shutdown configuration for the lab. This controls whether actions are taken on resources that are sitting idle.
 * @property connectionProfile The connection profile for the lab. This controls settings such as web access to lab resources or whether RDP or SSH ports are open.
 * @property description The description of the lab.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property labPlanId The ID of the lab plan. Used during resource creation to provide defaults and acts as a permission container when creating a lab via labs.azure.com. Setting a labPlanId on an existing lab provides organization..
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property networkProfile The network profile for the lab, typically applied via a lab plan. This profile cannot be modified once a lab has been created.
 * @property provisioningState Current provisioning state of the lab.
 * @property rosterProfile The lab user list management profile.
 * @property securityProfile The lab security profile.
 * @property state The lab state.
 * @property systemData Metadata pertaining to creation and last modification of the lab.
 * @property tags Resource tags.
 * @property title The title of the lab.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property virtualMachineProfile The profile used for creating lab virtual machines.
 */
public data class GetLabResult(
    public val autoShutdownProfile: AutoShutdownProfileResponse,
    public val connectionProfile: ConnectionProfileResponse,
    public val description: String? = null,
    public val id: String,
    public val labPlanId: String? = null,
    public val location: String,
    public val name: String,
    public val networkProfile: LabNetworkProfileResponse? = null,
    public val provisioningState: String,
    public val rosterProfile: RosterProfileResponse? = null,
    public val securityProfile: SecurityProfileResponse,
    public val state: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val title: String? = null,
    public val type: String,
    public val virtualMachineProfile: VirtualMachineProfileResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.GetLabResult): GetLabResult = GetLabResult(
            autoShutdownProfile = javaType.autoShutdownProfile().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.AutoShutdownProfileResponse.Companion.toKotlin(args0)
            }),
            connectionProfile = javaType.connectionProfile().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.ConnectionProfileResponse.Companion.toKotlin(args0)
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            labPlanId = javaType.labPlanId().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            networkProfile = javaType.networkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.labservices.kotlin.outputs.LabNetworkProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            rosterProfile = javaType.rosterProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.labservices.kotlin.outputs.RosterProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            securityProfile = javaType.securityProfile().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.SecurityProfileResponse.Companion.toKotlin(args0)
            }),
            state = javaType.state(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            virtualMachineProfile = javaType.virtualMachineProfile().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.VirtualMachineProfileResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
