@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * This represents the details about a lab that the User is in, and its state.
 * @property id The Id of the lab.
 * @property name Name of the lab
 * @property provisioningState The provisioning state of the lab.
 * @property usageQuota The maximum duration a user can use a VM in this lab.
 */
public data class LabDetailsResponse(
    public val id: String? = null,
    public val name: String? = null,
    public val provisioningState: String? = null,
    public val usageQuota: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.LabDetailsResponse): LabDetailsResponse = LabDetailsResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            usageQuota = javaType.usageQuota(),
        )
    }
}
