@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Profile for how to handle networking for Labs.
 * @property loadBalancerId The external load balancer resource id
 * @property publicIpId The external public IP resource id
 * @property subnetId The external subnet resource id
 */
public data class LabNetworkProfileResponse(
    public val loadBalancerId: String? = null,
    public val publicIpId: String? = null,
    public val subnetId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.LabNetworkProfileResponse): LabNetworkProfileResponse = LabNetworkProfileResponse(
            loadBalancerId = javaType.loadBalancerId().map({ args0 -> args0 }).orElse(null),
            publicIpId = javaType.publicIpId().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
