@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents the status of an operation that used the batch API.
 * @property operationUrl status of the long running operation for an environment
 * @property status status of the long running operation for an environment
 */
public data class OperationBatchStatusResponseItemResponse(
    public val operationUrl: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.OperationBatchStatusResponseItemResponse): OperationBatchStatusResponseItemResponse = OperationBatchStatusResponseItemResponse(
            operationUrl = javaType.operationUrl(),
            status = javaType.status(),
        )
    }
}
