@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of a Reference Vm
 * @property password The password of the virtual machine. This will be set to null in GET resource API
 * @property userName The username of the virtual machine
 * @property vmResourceId VM resource Id for the environment
 * @property vmStateDetails The state details for the reference virtual machine.
 */
public data class ReferenceVmResponse(
    public val password: String? = null,
    public val userName: String,
    public val vmResourceId: String,
    public val vmStateDetails: VmStateDetailsResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.ReferenceVmResponse): ReferenceVmResponse = ReferenceVmResponse(
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            userName = javaType.userName(),
            vmResourceId = javaType.vmResourceId(),
            vmStateDetails = javaType.vmStateDetails().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.VmStateDetailsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
