@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Represents resource specific settings
 * @property cores The translated compute cores of the virtual machine
 * @property galleryImageResourceId The resource id of the gallery image used for creating the virtual machine
 * @property id The unique id of the resource setting
 * @property imageName The name of the image used to created the environment setting
 * @property referenceVm Details specific to Reference Vm
 * @property size The size of the virtual machine
 */
public data class ResourceSettingsResponse(
    public val cores: Int,
    public val galleryImageResourceId: String? = null,
    public val id: String,
    public val imageName: String,
    public val referenceVm: ReferenceVmResponse,
    public val size: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.ResourceSettingsResponse): ResourceSettingsResponse = ResourceSettingsResponse(
            cores = javaType.cores(),
            galleryImageResourceId = javaType.galleryImageResourceId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            imageName = javaType.imageName(),
            referenceVm = javaType.referenceVm().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.ReferenceVmResponse.Companion.toKotlin(args0)
            }),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
        )
    }
}
