@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The lab security profile.
 * @property openAccess Whether any user or only specified users can register to a lab.
 * @property registrationCode The registration code for the lab.
 */
public data class SecurityProfileResponse(
    public val openAccess: String? = null,
    public val registrationCode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.SecurityProfileResponse): SecurityProfileResponse = SecurityProfileResponse(
            openAccess = javaType.openAccess().map({ args0 -> args0 }).orElse(null),
            registrationCode = javaType.registrationCode(),
        )
    }
}
