@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents the size configuration under the lab account
 * @property environmentSizes Represents a list of size categories supported by this Lab Account (Small, Medium, Large)
 */
public data class SizeConfigurationPropertiesResponse(
    public val environmentSizes: List<EnvironmentSizeResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.SizeConfigurationPropertiesResponse): SizeConfigurationPropertiesResponse = SizeConfigurationPropertiesResponse(
            environmentSizes = javaType.environmentSizes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.labservices.kotlin.outputs.EnvironmentSizeResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
