@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Support contact information and instructions.
 * @property email Support contact email address.
 * @property instructions Support instructions.
 * @property phone Support contact phone number.
 * @property url Support web address.
 */
public data class SupportInfoResponse(
    public val email: String? = null,
    public val instructions: String? = null,
    public val phone: String? = null,
    public val url: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.SupportInfoResponse): SupportInfoResponse = SupportInfoResponse(
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            instructions = javaType.instructions().map({ args0 -> args0 }).orElse(null),
            phone = javaType.phone().map({ args0 -> args0 }).orElse(null),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
        )
    }
}
