@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The additional capabilities for a lab VM.
 * @property installGpuDrivers Flag to pre-install dedicated GPU drivers.
 */
public data class VirtualMachineAdditionalCapabilitiesResponse(
    public val installGpuDrivers: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.VirtualMachineAdditionalCapabilitiesResponse): VirtualMachineAdditionalCapabilitiesResponse = VirtualMachineAdditionalCapabilitiesResponse(
            installGpuDrivers = javaType.installGpuDrivers().map({ args0 -> args0 }).orElse(null),
        )
    }
}
