@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.loadtestservice.kotlin

import com.pulumi.azurenative.loadtestservice.kotlin.outputs.EncryptionPropertiesResponse
import com.pulumi.azurenative.loadtestservice.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.loadtestservice.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.loadtestservice.kotlin.outputs.EncryptionPropertiesResponse.Companion.toKotlin as encryptionPropertiesResponseToKotlin
import com.pulumi.azurenative.loadtestservice.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.loadtestservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [LoadTest].
 */
@PulumiTagMarker
public class LoadTestResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoadTestArgs = LoadTestArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoadTestArgsBuilder.() -> Unit) {
        val builder = LoadTestArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LoadTest {
        val builtJavaResource = com.pulumi.azurenative.loadtestservice.LoadTest(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LoadTest(builtJavaResource)
    }
}

/**
 * LoadTest details.
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * Other available API versions: 2021-12-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:loadtestservice:LoadTest myLoadTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LoadTestService/loadTests/{loadTestName}
 * ```
 */
public class LoadTest internal constructor(
    override val javaResource: com.pulumi.azurenative.loadtestservice.LoadTest,
) : KotlinCustomResource(javaResource, LoadTestMapper) {
    /**
     * Resource data plane URI.
     */
    public val dataPlaneURI: Output<String>
        get() = javaResource.dataPlaneURI().applyValue({ args0 -> args0 })

    /**
     * Description of the resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * CMK Encryption property.
     */
    public val encryption: Output<EncryptionPropertiesResponse>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    encryptionPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The managed service identities assigned to this resource.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LoadTestMapper : ResourceMapper<LoadTest> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.loadtestservice.LoadTest::class == javaResource::class

    override fun map(javaResource: Resource): LoadTest = LoadTest(
        javaResource as
            com.pulumi.azurenative.loadtestservice.LoadTest,
    )
}

/**
 * @see [LoadTest].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoadTest].
 */
public suspend fun loadTest(name: String, block: suspend LoadTestResourceBuilder.() -> Unit): LoadTest {
    val builder = LoadTestResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoadTest].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loadTest(name: String): LoadTest {
    val builder = LoadTestResourceBuilder()
    builder.name(name)
    return builder.build()
}
