@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.loadtestservice.kotlin.inputs

import com.pulumi.azurenative.loadtestservice.inputs.EncryptionPropertiesIdentityArgs.builder
import com.pulumi.azurenative.loadtestservice.kotlin.enums.Type
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
 * @property resourceId User assigned identity to use for accessing key encryption key Url. Ex: /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/<resource group>/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId.
 * @property type Managed identity type to use for accessing encryption key Url.
 */
public data class EncryptionPropertiesIdentityArgs(
    public val resourceId: Output<String>? = null,
    public val type: Output<Either<String, Type>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.loadtestservice.inputs.EncryptionPropertiesIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.loadtestservice.inputs.EncryptionPropertiesIdentityArgs =
        com.pulumi.azurenative.loadtestservice.inputs.EncryptionPropertiesIdentityArgs.builder()
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EncryptionPropertiesIdentityArgs].
 */
@PulumiTagMarker
public class EncryptionPropertiesIdentityArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    private var type: Output<Either<String, Type>>? = null

    /**
     * @param value User assigned identity to use for accessing key encryption key Url. Ex: /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/<resource group>/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId.
     */
    @JvmName("gvyftqeovjeqhpvi")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Managed identity type to use for accessing encryption key Url.
     */
    @JvmName("rmucekmiodnpubyb")
    public suspend fun type(`value`: Output<Either<String, Type>>) {
        this.type = value
    }

    /**
     * @param value User assigned identity to use for accessing key encryption key Url. Ex: /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/<resource group>/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId.
     */
    @JvmName("hhfsxaaengsewmog")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Managed identity type to use for accessing encryption key Url.
     */
    @JvmName("ubqxpxmpuurahkfw")
    public suspend fun type(`value`: Either<String, Type>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Managed identity type to use for accessing encryption key Url.
     */
    @JvmName("nsjpokafjiswvded")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Managed identity type to use for accessing encryption key Url.
     */
    @JvmName("mhhlfknmswmcbttx")
    public fun type(`value`: Type) {
        val toBeMapped = Either.ofRight<String, Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EncryptionPropertiesIdentityArgs = EncryptionPropertiesIdentityArgs(
        resourceId = resourceId,
        type = type,
    )
}
