@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.loadtestservice.kotlin.inputs

import com.pulumi.azurenative.loadtestservice.inputs.GetLoadTestPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property loadTestName Load Test name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetLoadTestPlainArgs(
    public val loadTestName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.loadtestservice.inputs.GetLoadTestPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.loadtestservice.inputs.GetLoadTestPlainArgs =
        com.pulumi.azurenative.loadtestservice.inputs.GetLoadTestPlainArgs.builder()
            .loadTestName(loadTestName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLoadTestPlainArgs].
 */
@PulumiTagMarker
public class GetLoadTestPlainArgsBuilder internal constructor() {
    private var loadTestName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Load Test name
     */
    @JvmName("gpdlsohliyexvahe")
    public suspend fun loadTestName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.loadTestName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yhjgqgngwvphwcsy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLoadTestPlainArgs = GetLoadTestPlainArgs(
        loadTestName = loadTestName ?: throw PulumiNullFieldException("loadTestName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
