@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.loadtestservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
 * @property resourceId User assigned identity to use for accessing key encryption key Url. Ex: /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/<resource group>/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId.
 * @property type Managed identity type to use for accessing encryption key Url.
 */
public data class EncryptionPropertiesIdentityResponse(
    public val resourceId: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.loadtestservice.outputs.EncryptionPropertiesIdentityResponse): EncryptionPropertiesIdentityResponse = EncryptionPropertiesIdentityResponse(
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
