@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.kotlin.outputs.AgreementContentResponse
import com.pulumi.azurenative.logic.kotlin.outputs.BusinessIdentityResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.logic.kotlin.outputs.AgreementContentResponse.Companion.toKotlin as agreementContentResponseToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.BusinessIdentityResponse.Companion.toKotlin as businessIdentityResponseToKotlin

/**
 * Builder for [IntegrationAccountAgreement].
 */
@PulumiTagMarker
public class IntegrationAccountAgreementResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationAccountAgreementArgs = IntegrationAccountAgreementArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationAccountAgreementArgsBuilder.() -> Unit) {
        val builder = IntegrationAccountAgreementArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IntegrationAccountAgreement {
        val builtJavaResource =
            com.pulumi.azurenative.logic.IntegrationAccountAgreement(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IntegrationAccountAgreement(builtJavaResource)
    }
}

/**
 * The integration account agreement.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2015-08-01-preview.
 * ## Example Usage
 * ### Create or update an agreement
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationAccountAgreement = new AzureNative.Logic.IntegrationAccountAgreement("integrationAccountAgreement", new()
 *     {
 *         AgreementName = "testAgreement",
 *         AgreementType = AzureNative.Logic.AgreementType.AS2,
 *         Content = new AzureNative.Logic.Inputs.AgreementContentArgs
 *         {
 *             AS2 = new AzureNative.Logic.Inputs.AS2AgreementContentArgs
 *             {
 *                 ReceiveAgreement = new AzureNative.Logic.Inputs.AS2OneWayAgreementArgs
 *                 {
 *                     ProtocolSettings = new AzureNative.Logic.Inputs.AS2ProtocolSettingsArgs
 *                     {
 *                         AcknowledgementConnectionSettings = new AzureNative.Logic.Inputs.AS2AcknowledgementConnectionSettingsArgs
 *                         {
 *                             IgnoreCertificateNameMismatch = true,
 *                             KeepHttpConnectionAlive = true,
 *                             SupportHttpStatusCodeContinue = true,
 *                             UnfoldHttpHeaders = true,
 *                         },
 *                         EnvelopeSettings = new AzureNative.Logic.Inputs.AS2EnvelopeSettingsArgs
 *                         {
 *                             AutogenerateFileName = true,
 *                             FileNameTemplate = "Test",
 *                             MessageContentType = "text/plain",
 *                             SuspendMessageOnFileNameGenerationError = true,
 *                             TransmitFileNameInMimeHeader = true,
 *                         },
 *                         ErrorSettings = new AzureNative.Logic.Inputs.AS2ErrorSettingsArgs
 *                         {
 *                             ResendIfMDNNotReceived = true,
 *                             SuspendDuplicateMessage = true,
 *                         },
 *                         MdnSettings = new AzureNative.Logic.Inputs.AS2MdnSettingsArgs
 *                         {
 *                             DispositionNotificationTo = "http://tempuri.org",
 *                             MdnText = "Sample",
 *                             MicHashingAlgorithm = AzureNative.Logic.HashingAlgorithm.SHA1,
 *                             NeedMDN = true,
 *                             ReceiptDeliveryUrl = "http://tempuri.org",
 *                             SendInboundMDNToMessageBox = true,
 *                             SendMDNAsynchronously = true,
 *                             SignMDN = true,
 *                             SignOutboundMDNIfOptional = true,
 *                         },
 *                         MessageConnectionSettings = new AzureNative.Logic.Inputs.AS2MessageConnectionSettingsArgs
 *                         {
 *                             IgnoreCertificateNameMismatch = true,
 *                             KeepHttpConnectionAlive = true,
 *                             SupportHttpStatusCodeContinue = true,
 *                             UnfoldHttpHeaders = true,
 *                         },
 *                         SecuritySettings = new AzureNative.Logic.Inputs.AS2SecuritySettingsArgs
 *                         {
 *                             EnableNRRForInboundDecodedMessages = true,
 *                             EnableNRRForInboundEncodedMessages = true,
 *                             EnableNRRForInboundMDN = true,
 *                             EnableNRRForOutboundDecodedMessages = true,
 *                             EnableNRRForOutboundEncodedMessages = true,
 *                             EnableNRRForOutboundMDN = true,
 *                             OverrideGroupSigningCertificate = false,
 *                         },
 *                         ValidationSettings = new AzureNative.Logic.Inputs.AS2ValidationSettingsArgs
 *                         {
 *                             CheckCertificateRevocationListOnReceive = true,
 *                             CheckCertificateRevocationListOnSend = true,
 *                             CheckDuplicateMessage = true,
 *                             CompressMessage = true,
 *                             EncryptMessage = false,
 *                             EncryptionAlgorithm = AzureNative.Logic.EncryptionAlgorithm.AES128,
 *                             InterchangeDuplicatesValidityDays = 100,
 *                             OverrideMessageProperties = true,
 *                             SignMessage = false,
 *                         },
 *                     },
 *                     ReceiverBusinessIdentity = new AzureNative.Logic.Inputs.BusinessIdentityArgs
 *                     {
 *                         Qualifier = "ZZ",
 *                         Value = "ZZ",
 *                     },
 *                     SenderBusinessIdentity = new AzureNative.Logic.Inputs.BusinessIdentityArgs
 *                     {
 *                         Qualifier = "AA",
 *                         Value = "AA",
 *                     },
 *                 },
 *                 SendAgreement = new AzureNative.Logic.Inputs.AS2OneWayAgreementArgs
 *                 {
 *                     ProtocolSettings = new AzureNative.Logic.Inputs.AS2ProtocolSettingsArgs
 *                     {
 *                         AcknowledgementConnectionSettings = new AzureNative.Logic.Inputs.AS2AcknowledgementConnectionSettingsArgs
 *                         {
 *                             IgnoreCertificateNameMismatch = true,
 *                             KeepHttpConnectionAlive = true,
 *                             SupportHttpStatusCodeContinue = true,
 *                             UnfoldHttpHeaders = true,
 *                         },
 *                         EnvelopeSettings = new AzureNative.Logic.Inputs.AS2EnvelopeSettingsArgs
 *                         {
 *                             AutogenerateFileName = true,
 *                             FileNameTemplate = "Test",
 *                             MessageContentType = "text/plain",
 *                             SuspendMessageOnFileNameGenerationError = true,
 *                             TransmitFileNameInMimeHeader = true,
 *                         },
 *                         ErrorSettings = new AzureNative.Logic.Inputs.AS2ErrorSettingsArgs
 *                         {
 *                             ResendIfMDNNotReceived = true,
 *                             SuspendDuplicateMessage = true,
 *                         },
 *                         MdnSettings = new AzureNative.Logic.Inputs.AS2MdnSettingsArgs
 *                         {
 *                             DispositionNotificationTo = "http://tempuri.org",
 *                             MdnText = "Sample",
 *                             MicHashingAlgorithm = AzureNative.Logic.HashingAlgorithm.SHA1,
 *                             NeedMDN = true,
 *                             ReceiptDeliveryUrl = "http://tempuri.org",
 *                             SendInboundMDNToMessageBox = true,
 *                             SendMDNAsynchronously = true,
 *                             SignMDN = true,
 *                             SignOutboundMDNIfOptional = true,
 *                         },
 *                         MessageConnectionSettings = new AzureNative.Logic.Inputs.AS2MessageConnectionSettingsArgs
 *                         {
 *                             IgnoreCertificateNameMismatch = true,
 *                             KeepHttpConnectionAlive = true,
 *                             SupportHttpStatusCodeContinue = true,
 *                             UnfoldHttpHeaders = true,
 *                         },
 *                         SecuritySettings = new AzureNative.Logic.Inputs.AS2SecuritySettingsArgs
 *                         {
 *                             EnableNRRForInboundDecodedMessages = true,
 *                             EnableNRRForInboundEncodedMessages = true,
 *                             EnableNRRForInboundMDN = true,
 *                             EnableNRRForOutboundDecodedMessages = true,
 *                             EnableNRRForOutboundEncodedMessages = true,
 *                             EnableNRRForOutboundMDN = true,
 *                             OverrideGroupSigningCertificate = false,
 *                         },
 *                         ValidationSettings = new AzureNative.Logic.Inputs.AS2ValidationSettingsArgs
 *                         {
 *                             CheckCertificateRevocationListOnReceive = true,
 *                             CheckCertificateRevocationListOnSend = true,
 *                             CheckDuplicateMessage = true,
 *                             CompressMessage = true,
 *                             EncryptMessage = false,
 *                             EncryptionAlgorithm = AzureNative.Logic.EncryptionAlgorithm.AES128,
 *                             InterchangeDuplicatesValidityDays = 100,
 *                             OverrideMessageProperties = true,
 *                             SignMessage = false,
 *                         },
 *                     },
 *                     ReceiverBusinessIdentity = new AzureNative.Logic.Inputs.BusinessIdentityArgs
 *                     {
 *                         Qualifier = "AA",
 *                         Value = "AA",
 *                     },
 *                     SenderBusinessIdentity = new AzureNative.Logic.Inputs.BusinessIdentityArgs
 *                     {
 *                         Qualifier = "ZZ",
 *                         Value = "ZZ",
 *                     },
 *                 },
 *             },
 *         },
 *         GuestIdentity = new AzureNative.Logic.Inputs.BusinessIdentityArgs
 *         {
 *             Qualifier = "AA",
 *             Value = "AA",
 *         },
 *         GuestPartner = "GuestPartner",
 *         HostIdentity = new AzureNative.Logic.Inputs.BusinessIdentityArgs
 *         {
 *             Qualifier = "ZZ",
 *             Value = "ZZ",
 *         },
 *         HostPartner = "HostPartner",
 *         IntegrationAccountName = "testIntegrationAccount",
 *         Location = "westus",
 *         Metadata = null,
 *         ResourceGroupName = "testResourceGroup",
 *         Tags =
 *         {
 *             { "IntegrationAccountAgreement", "<IntegrationAccountAgreementName>" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewIntegrationAccountAgreement(ctx, "integrationAccountAgreement", &logic.IntegrationAccountAgreementArgs{
 * 			AgreementName: pulumi.String("testAgreement"),
 * 			AgreementType: logic.AgreementTypeAS2,
 * 			Content: &logic.AgreementContentArgs{
 * 				AS2: &logic.AS2AgreementContentArgs{
 * 					ReceiveAgreement: &logic.AS2OneWayAgreementArgs{
 * 						ProtocolSettings: &logic.AS2ProtocolSettingsArgs{
 * 							AcknowledgementConnectionSettings: &logic.AS2AcknowledgementConnectionSettingsArgs{
 * 								IgnoreCertificateNameMismatch: pulumi.Bool(true),
 * 								KeepHttpConnectionAlive:       pulumi.Bool(true),
 * 								SupportHttpStatusCodeContinue: pulumi.Bool(true),
 * 								UnfoldHttpHeaders:             pulumi.Bool(true),
 * 							},
 * 							EnvelopeSettings: &logic.AS2EnvelopeSettingsArgs{
 * 								AutogenerateFileName:                    pulumi.Bool(true),
 * 								FileNameTemplate:                        pulumi.String("Test"),
 * 								MessageContentType:                      pulumi.String("text/plain"),
 * 								SuspendMessageOnFileNameGenerationError: pulumi.Bool(true),
 * 								TransmitFileNameInMimeHeader:            pulumi.Bool(true),
 * 							},
 * 							ErrorSettings: &logic.AS2ErrorSettingsArgs{
 * 								ResendIfMDNNotReceived:  pulumi.Bool(true),
 * 								SuspendDuplicateMessage: pulumi.Bool(true),
 * 							},
 * 							MdnSettings: &logic.AS2MdnSettingsArgs{
 * 								DispositionNotificationTo:  pulumi.String("http://tempuri.org"),
 * 								MdnText:                    pulumi.String("Sample"),
 * 								MicHashingAlgorithm:        pulumi.String(logic.HashingAlgorithmSHA1),
 * 								NeedMDN:                    pulumi.Bool(true),
 * 								ReceiptDeliveryUrl:         pulumi.String("http://tempuri.org"),
 * 								SendInboundMDNToMessageBox: pulumi.Bool(true),
 * 								SendMDNAsynchronously:      pulumi.Bool(true),
 * 								SignMDN:                    pulumi.Bool(true),
 * 								SignOutboundMDNIfOptional:  pulumi.Bool(true),
 * 							},
 * 							MessageConnectionSettings: &logic.AS2MessageConnectionSettingsArgs{
 * 								IgnoreCertificateNameMismatch: pulumi.Bool(true),
 * 								KeepHttpConnectionAlive:       pulumi.Bool(true),
 * 								SupportHttpStatusCodeContinue: pulumi.Bool(true),
 * 								UnfoldHttpHeaders:             pulumi.Bool(true),
 * 							},
 * 							SecuritySettings: &logic.AS2SecuritySettingsArgs{
 * 								EnableNRRForInboundDecodedMessages:  pulumi.Bool(true),
 * 								EnableNRRForInboundEncodedMessages:  pulumi.Bool(true),
 * 								EnableNRRForInboundMDN:              pulumi.Bool(true),
 * 								EnableNRRForOutboundDecodedMessages: pulumi.Bool(true),
 * 								EnableNRRForOutboundEncodedMessages: pulumi.Bool(true),
 * 								EnableNRRForOutboundMDN:             pulumi.Bool(true),
 * 								OverrideGroupSigningCertificate:     pulumi.Bool(false),
 * 							},
 * 							ValidationSettings: &logic.AS2ValidationSettingsArgs{
 * 								CheckCertificateRevocationListOnReceive: pulumi.Bool(true),
 * 								CheckCertificateRevocationListOnSend:    pulumi.Bool(true),
 * 								CheckDuplicateMessage:                   pulumi.Bool(true),
 * 								CompressMessage:                         pulumi.Bool(true),
 * 								EncryptMessage:                          pulumi.Bool(false),
 * 								EncryptionAlgorithm:                     pulumi.String(logic.EncryptionAlgorithmAES128),
 * 								InterchangeDuplicatesValidityDays:       pulumi.Int(100),
 * 								OverrideMessageProperties:               pulumi.Bool(true),
 * 								SignMessage:                             pulumi.Bool(false),
 * 							},
 * 						},
 * 						ReceiverBusinessIdentity: &logic.BusinessIdentityArgs{
 * 							Qualifier: pulumi.String("ZZ"),
 * 							Value:     pulumi.String("ZZ"),
 * 						},
 * 						SenderBusinessIdentity: &logic.BusinessIdentityArgs{
 * 							Qualifier: pulumi.String("AA"),
 * 							Value:     pulumi.String("AA"),
 * 						},
 * 					},
 * 					SendAgreement: &logic.AS2OneWayAgreementArgs{
 * 						ProtocolSettings: &logic.AS2ProtocolSettingsArgs{
 * 							AcknowledgementConnectionSettings: &logic.AS2AcknowledgementConnectionSettingsArgs{
 * 								IgnoreCertificateNameMismatch: pulumi.Bool(true),
 * 								KeepHttpConnectionAlive:       pulumi.Bool(true),
 * 								SupportHttpStatusCodeContinue: pulumi.Bool(true),
 * 								UnfoldHttpHeaders:             pulumi.Bool(true),
 * 							},
 * 							EnvelopeSettings: &logic.AS2EnvelopeSettingsArgs{
 * 								AutogenerateFileName:                    pulumi.Bool(true),
 * 								FileNameTemplate:                        pulumi.String("Test"),
 * 								MessageContentType:                      pulumi.String("text/plain"),
 * 								SuspendMessageOnFileNameGenerationError: pulumi.Bool(true),
 * 								TransmitFileNameInMimeHeader:            pulumi.Bool(true),
 * 							},
 * 							ErrorSettings: &logic.AS2ErrorSettingsArgs{
 * 								ResendIfMDNNotReceived:  pulumi.Bool(true),
 * 								SuspendDuplicateMessage: pulumi.Bool(true),
 * 							},
 * 							MdnSettings: &logic.AS2MdnSettingsArgs{
 * 								DispositionNotificationTo:  pulumi.String("http://tempuri.org"),
 * 								MdnText:                    pulumi.String("Sample"),
 * 								MicHashingAlgorithm:        pulumi.String(logic.HashingAlgorithmSHA1),
 * 								NeedMDN:                    pulumi.Bool(true),
 * 								ReceiptDeliveryUrl:         pulumi.String("http://tempuri.org"),
 * 								SendInboundMDNToMessageBox: pulumi.Bool(true),
 * 								SendMDNAsynchronously:      pulumi.Bool(true),
 * 								SignMDN:                    pulumi.Bool(true),
 * 								SignOutboundMDNIfOptional:  pulumi.Bool(true),
 * 							},
 * 							MessageConnectionSettings: &logic.AS2MessageConnectionSettingsArgs{
 * 								IgnoreCertificateNameMismatch: pulumi.Bool(true),
 * 								KeepHttpConnectionAlive:       pulumi.Bool(true),
 * 								SupportHttpStatusCodeContinue: pulumi.Bool(true),
 * 								UnfoldHttpHeaders:             pulumi.Bool(true),
 * 							},
 * 							SecuritySettings: &logic.AS2SecuritySettingsArgs{
 * 								EnableNRRForInboundDecodedMessages:  pulumi.Bool(true),
 * 								EnableNRRForInboundEncodedMessages:  pulumi.Bool(true),
 * 								EnableNRRForInboundMDN:              pulumi.Bool(true),
 * 								EnableNRRForOutboundDecodedMessages: pulumi.Bool(true),
 * 								EnableNRRForOutboundEncodedMessages: pulumi.Bool(true),
 * 								EnableNRRForOutboundMDN:             pulumi.Bool(true),
 * 								OverrideGroupSigningCertificate:     pulumi.Bool(false),
 * 							},
 * 							ValidationSettings: &logic.AS2ValidationSettingsArgs{
 * 								CheckCertificateRevocationListOnReceive: pulumi.Bool(true),
 * 								CheckCertificateRevocationListOnSend:    pulumi.Bool(true),
 * 								CheckDuplicateMessage:                   pulumi.Bool(true),
 * 								CompressMessage:                         pulumi.Bool(true),
 * 								EncryptMessage:                          pulumi.Bool(false),
 * 								EncryptionAlgorithm:                     pulumi.String(logic.EncryptionAlgorithmAES128),
 * 								InterchangeDuplicatesValidityDays:       pulumi.Int(100),
 * 								OverrideMessageProperties:               pulumi.Bool(true),
 * 								SignMessage:                             pulumi.Bool(false),
 * 							},
 * 						},
 * 						ReceiverBusinessIdentity: &logic.BusinessIdentityArgs{
 * 							Qualifier: pulumi.String("AA"),
 * 							Value:     pulumi.String("AA"),
 * 						},
 * 						SenderBusinessIdentity: &logic.BusinessIdentityArgs{
 * 							Qualifier: pulumi.String("ZZ"),
 * 							Value:     pulumi.String("ZZ"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			GuestIdentity: &logic.BusinessIdentityArgs{
 * 				Qualifier: pulumi.String("AA"),
 * 				Value:     pulumi.String("AA"),
 * 			},
 * 			GuestPartner: pulumi.String("GuestPartner"),
 * 			HostIdentity: &logic.BusinessIdentityArgs{
 * 				Qualifier: pulumi.String("ZZ"),
 * 				Value:     pulumi.String("ZZ"),
 * 			},
 * 			HostPartner:            pulumi.String("HostPartner"),
 * 			IntegrationAccountName: pulumi.String("testIntegrationAccount"),
 * 			Location:               pulumi.String("westus"),
 * 			Metadata:               pulumi.Any(nil),
 * 			ResourceGroupName:      pulumi.String("testResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"IntegrationAccountAgreement": pulumi.String("<IntegrationAccountAgreementName>"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationAccountAgreement;
 * import com.pulumi.azurenative.logic.IntegrationAccountAgreementArgs;
 * import com.pulumi.azurenative.logic.inputs.AgreementContentArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2AgreementContentArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2OneWayAgreementArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2ProtocolSettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2AcknowledgementConnectionSettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2EnvelopeSettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2ErrorSettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2MdnSettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2MessageConnectionSettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2SecuritySettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2ValidationSettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.BusinessIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationAccountAgreement = new IntegrationAccountAgreement("integrationAccountAgreement", IntegrationAccountAgreementArgs.builder()
 *             .agreementName("testAgreement")
 *             .agreementType("AS2")
 *             .content(AgreementContentArgs.builder()
 *                 .aS2(AS2AgreementContentArgs.builder()
 *                     .receiveAgreement(AS2OneWayAgreementArgs.builder()
 *                         .protocolSettings(AS2ProtocolSettingsArgs.builder()
 *                             .acknowledgementConnectionSettings(AS2AcknowledgementConnectionSettingsArgs.builder()
 *                                 .ignoreCertificateNameMismatch(true)
 *                                 .keepHttpConnectionAlive(true)
 *                                 .supportHttpStatusCodeContinue(true)
 *                                 .unfoldHttpHeaders(true)
 *                                 .build())
 *                             .envelopeSettings(AS2EnvelopeSettingsArgs.builder()
 *                                 .autogenerateFileName(true)
 *                                 .fileNameTemplate("Test")
 *                                 .messageContentType("text/plain")
 *                                 .suspendMessageOnFileNameGenerationError(true)
 *                                 .transmitFileNameInMimeHeader(true)
 *                                 .build())
 *                             .errorSettings(AS2ErrorSettingsArgs.builder()
 *                                 .resendIfMDNNotReceived(true)
 *                                 .suspendDuplicateMessage(true)
 *                                 .build())
 *                             .mdnSettings(AS2MdnSettingsArgs.builder()
 *                                 .dispositionNotificationTo("http://tempuri.org")
 *                                 .mdnText("Sample")
 *                                 .micHashingAlgorithm("SHA1")
 *                                 .needMDN(true)
 *                                 .receiptDeliveryUrl("http://tempuri.org")
 *                                 .sendInboundMDNToMessageBox(true)
 *                                 .sendMDNAsynchronously(true)
 *                                 .signMDN(true)
 *                                 .signOutboundMDNIfOptional(true)
 *                                 .build())
 *                             .messageConnectionSettings(AS2MessageConnectionSettingsArgs.builder()
 *                                 .ignoreCertificateNameMismatch(true)
 *                                 .keepHttpConnectionAlive(true)
 *                                 .supportHttpStatusCodeContinue(true)
 *                                 .unfoldHttpHeaders(true)
 *                                 .build())
 *                             .securitySettings(AS2SecuritySettingsArgs.builder()
 *                                 .enableNRRForInboundDecodedMessages(true)
 *                                 .enableNRRForInboundEncodedMessages(true)
 *                                 .enableNRRForInboundMDN(true)
 *                                 .enableNRRForOutboundDecodedMessages(true)
 *                                 .enableNRRForOutboundEncodedMessages(true)
 *                                 .enableNRRForOutboundMDN(true)
 *                                 .overrideGroupSigningCertificate(false)
 *                                 .build())
 *                             .validationSettings(AS2ValidationSettingsArgs.builder()
 *                                 .checkCertificateRevocationListOnReceive(true)
 *                                 .checkCertificateRevocationListOnSend(true)
 *                                 .checkDuplicateMessage(true)
 *                                 .compressMessage(true)
 *                                 .encryptMessage(false)
 *                                 .encryptionAlgorithm("AES128")
 *                                 .interchangeDuplicatesValidityDays(100)
 *                                 .overrideMessageProperties(true)
 *                                 .signMessage(false)
 *                                 .build())
 *                             .build())
 *                         .receiverBusinessIdentity(BusinessIdentityArgs.builder()
 *                             .qualifier("ZZ")
 *                             .value("ZZ")
 *                             .build())
 *                         .senderBusinessIdentity(BusinessIdentityArgs.builder()
 *                             .qualifier("AA")
 *                             .value("AA")
 *                             .build())
 *                         .build())
 *                     .sendAgreement(AS2OneWayAgreementArgs.builder()
 *                         .protocolSettings(AS2ProtocolSettingsArgs.builder()
 *                             .acknowledgementConnectionSettings(AS2AcknowledgementConnectionSettingsArgs.builder()
 *                                 .ignoreCertificateNameMismatch(true)
 *                                 .keepHttpConnectionAlive(true)
 *                                 .supportHttpStatusCodeContinue(true)
 *                                 .unfoldHttpHeaders(true)
 *                                 .build())
 *                             .envelopeSettings(AS2EnvelopeSettingsArgs.builder()
 *                                 .autogenerateFileName(true)
 *                                 .fileNameTemplate("Test")
 *                                 .messageContentType("text/plain")
 *                                 .suspendMessageOnFileNameGenerationError(true)
 *                                 .transmitFileNameInMimeHeader(true)
 *                                 .build())
 *                             .errorSettings(AS2ErrorSettingsArgs.builder()
 *                                 .resendIfMDNNotReceived(true)
 *                                 .suspendDuplicateMessage(true)
 *                                 .build())
 *                             .mdnSettings(AS2MdnSettingsArgs.builder()
 *                                 .dispositionNotificationTo("http://tempuri.org")
 *                                 .mdnText("Sample")
 *                                 .micHashingAlgorithm("SHA1")
 *                                 .needMDN(true)
 *                                 .receiptDeliveryUrl("http://tempuri.org")
 *                                 .sendInboundMDNToMessageBox(true)
 *                                 .sendMDNAsynchronously(true)
 *                                 .signMDN(true)
 *                                 .signOutboundMDNIfOptional(true)
 *                                 .build())
 *                             .messageConnectionSettings(AS2MessageConnectionSettingsArgs.builder()
 *                                 .ignoreCertificateNameMismatch(true)
 *                                 .keepHttpConnectionAlive(true)
 *                                 .supportHttpStatusCodeContinue(true)
 *                                 .unfoldHttpHeaders(true)
 *                                 .build())
 *                             .securitySettings(AS2SecuritySettingsArgs.builder()
 *                                 .enableNRRForInboundDecodedMessages(true)
 *                                 .enableNRRForInboundEncodedMessages(true)
 *                                 .enableNRRForInboundMDN(true)
 *                                 .enableNRRForOutboundDecodedMessages(true)
 *                                 .enableNRRForOutboundEncodedMessages(true)
 *                                 .enableNRRForOutboundMDN(true)
 *                                 .overrideGroupSigningCertificate(false)
 *                                 .build())
 *                             .validationSettings(AS2ValidationSettingsArgs.builder()
 *                                 .checkCertificateRevocationListOnReceive(true)
 *                                 .checkCertificateRevocationListOnSend(true)
 *                                 .checkDuplicateMessage(true)
 *                                 .compressMessage(true)
 *                                 .encryptMessage(false)
 *                                 .encryptionAlgorithm("AES128")
 *                                 .interchangeDuplicatesValidityDays(100)
 *                                 .overrideMessageProperties(true)
 *                                 .signMessage(false)
 *                                 .build())
 *                             .build())
 *                         .receiverBusinessIdentity(BusinessIdentityArgs.builder()
 *                             .qualifier("AA")
 *                             .value("AA")
 *                             .build())
 *                         .senderBusinessIdentity(BusinessIdentityArgs.builder()
 *                             .qualifier("ZZ")
 *                             .value("ZZ")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .guestIdentity(BusinessIdentityArgs.builder()
 *                 .qualifier("AA")
 *                 .value("AA")
 *                 .build())
 *             .guestPartner("GuestPartner")
 *             .hostIdentity(BusinessIdentityArgs.builder()
 *                 .qualifier("ZZ")
 *                 .value("ZZ")
 *                 .build())
 *             .hostPartner("HostPartner")
 *             .integrationAccountName("testIntegrationAccount")
 *             .location("westus")
 *             .metadata()
 *             .resourceGroupName("testResourceGroup")
 *             .tags(Map.of("IntegrationAccountAgreement", "<IntegrationAccountAgreementName>"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationAccountAgreement <IntegrationAccountAgreementName> /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements/{agreementName}
 * ```
 */
public class IntegrationAccountAgreement internal constructor(
    override val javaResource: com.pulumi.azurenative.logic.IntegrationAccountAgreement,
) : KotlinCustomResource(javaResource, IntegrationAccountAgreementMapper) {
    /**
     * The agreement type.
     */
    public val agreementType: Output<String>
        get() = javaResource.agreementType().applyValue({ args0 -> args0 })

    /**
     * The changed time.
     */
    public val changedTime: Output<String>
        get() = javaResource.changedTime().applyValue({ args0 -> args0 })

    /**
     * The agreement content.
     */
    public val content: Output<AgreementContentResponse>
        get() = javaResource.content().applyValue({ args0 ->
            args0.let({ args0 ->
                agreementContentResponseToKotlin(args0)
            })
        })

    /**
     * The created time.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * The business identity of the guest partner.
     */
    public val guestIdentity: Output<BusinessIdentityResponse>
        get() = javaResource.guestIdentity().applyValue({ args0 ->
            args0.let({ args0 ->
                businessIdentityResponseToKotlin(args0)
            })
        })

    /**
     * The integration account partner that is set as guest partner for this agreement.
     */
    public val guestPartner: Output<String>
        get() = javaResource.guestPartner().applyValue({ args0 -> args0 })

    /**
     * The business identity of the host partner.
     */
    public val hostIdentity: Output<BusinessIdentityResponse>
        get() = javaResource.hostIdentity().applyValue({ args0 ->
            args0.let({ args0 ->
                businessIdentityResponseToKotlin(args0)
            })
        })

    /**
     * The integration account partner that is set as host partner for this agreement.
     */
    public val hostPartner: Output<String>
        get() = javaResource.hostPartner().applyValue({ args0 -> args0 })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The metadata.
     */
    public val metadata: Output<Any>?
        get() = javaResource.metadata().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets the resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets the resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IntegrationAccountAgreementMapper : ResourceMapper<IntegrationAccountAgreement> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.logic.IntegrationAccountAgreement::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationAccountAgreement =
        IntegrationAccountAgreement(
            javaResource as
                com.pulumi.azurenative.logic.IntegrationAccountAgreement,
        )
}

/**
 * @see [IntegrationAccountAgreement].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationAccountAgreement].
 */
public suspend fun integrationAccountAgreement(
    name: String,
    block: suspend IntegrationAccountAgreementResourceBuilder.() -> Unit,
): IntegrationAccountAgreement {
    val builder = IntegrationAccountAgreementResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationAccountAgreement].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationAccountAgreement(name: String): IntegrationAccountAgreement {
    val builder = IntegrationAccountAgreementResourceBuilder()
    builder.name(name)
    return builder.build()
}
