@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.IntegrationAccountArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.WorkflowState
import com.pulumi.azurenative.logic.kotlin.inputs.IntegrationAccountSkuArgs
import com.pulumi.azurenative.logic.kotlin.inputs.IntegrationAccountSkuArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.ResourceReferenceArgs
import com.pulumi.azurenative.logic.kotlin.inputs.ResourceReferenceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The integration account.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2015-08-01-preview.
 * ## Example Usage
 * ### Create or update an integration account
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationAccount = new AzureNative.Logic.IntegrationAccount("integrationAccount", new()
 *     {
 *         IntegrationAccountName = "testIntegrationAccount",
 *         Location = "westus",
 *         ResourceGroupName = "testResourceGroup",
 *         Sku = new AzureNative.Logic.Inputs.IntegrationAccountSkuArgs
 *         {
 *             Name = AzureNative.Logic.IntegrationAccountSkuName.Standard,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewIntegrationAccount(ctx, "integrationAccount", &logic.IntegrationAccountArgs{
 * 			IntegrationAccountName: pulumi.String("testIntegrationAccount"),
 * 			Location:               pulumi.String("westus"),
 * 			ResourceGroupName:      pulumi.String("testResourceGroup"),
 * 			Sku: &logic.IntegrationAccountSkuArgs{
 * 				Name: pulumi.String(logic.IntegrationAccountSkuNameStandard),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationAccount;
 * import com.pulumi.azurenative.logic.IntegrationAccountArgs;
 * import com.pulumi.azurenative.logic.inputs.IntegrationAccountSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationAccount = new IntegrationAccount("integrationAccount", IntegrationAccountArgs.builder()
 *             .integrationAccountName("testIntegrationAccount")
 *             .location("westus")
 *             .resourceGroupName("testResourceGroup")
 *             .sku(IntegrationAccountSkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationAccount testIntegrationAccount /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}
 * ```
 * @property integrationAccountName The integration account name.
 * @property integrationServiceEnvironment The integration service environment.
 * @property location The resource location.
 * @property resourceGroupName The resource group name.
 * @property sku The sku.
 * @property state The workflow state.
 * @property tags The resource tags.
 */
public data class IntegrationAccountArgs(
    public val integrationAccountName: Output<String>? = null,
    public val integrationServiceEnvironment: Output<ResourceReferenceArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<IntegrationAccountSkuArgs>? = null,
    public val state: Output<Either<String, WorkflowState>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.IntegrationAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.IntegrationAccountArgs =
        com.pulumi.azurenative.logic.IntegrationAccountArgs.builder()
            .integrationAccountName(integrationAccountName?.applyValue({ args0 -> args0 }))
            .integrationServiceEnvironment(
                integrationServiceEnvironment?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IntegrationAccountArgs].
 */
@PulumiTagMarker
public class IntegrationAccountArgsBuilder internal constructor() {
    private var integrationAccountName: Output<String>? = null

    private var integrationServiceEnvironment: Output<ResourceReferenceArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<IntegrationAccountSkuArgs>? = null

    private var state: Output<Either<String, WorkflowState>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The integration account name.
     */
    @JvmName("jmrhfgmpishudjrm")
    public suspend fun integrationAccountName(`value`: Output<String>) {
        this.integrationAccountName = value
    }

    /**
     * @param value The integration service environment.
     */
    @JvmName("dbusvcefoxyvopbi")
    public suspend fun integrationServiceEnvironment(`value`: Output<ResourceReferenceArgs>) {
        this.integrationServiceEnvironment = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("jjvbpdmxwqpoaxwy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("bpyklsudhroqvkfk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The sku.
     */
    @JvmName("atraqswvnkswyocr")
    public suspend fun sku(`value`: Output<IntegrationAccountSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The workflow state.
     */
    @JvmName("dfbflcovqdduysna")
    public suspend fun state(`value`: Output<Either<String, WorkflowState>>) {
        this.state = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("vytmocnjtmrvcnnt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("qearfobjyqcqfxoi")
    public suspend fun integrationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The integration service environment.
     */
    @JvmName("xetaprcobceqrliw")
    public suspend fun integrationServiceEnvironment(`value`: ResourceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationServiceEnvironment = mapped
    }

    /**
     * @param argument The integration service environment.
     */
    @JvmName("jujyjoyqxewfjjrj")
    public suspend fun integrationServiceEnvironment(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.integrationServiceEnvironment = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("djpwmjhqiqxrkipi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("tpenonnrxawjxaoh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The sku.
     */
    @JvmName("xyxovaejafildwhx")
    public suspend fun sku(`value`: IntegrationAccountSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The sku.
     */
    @JvmName("ynxtesawgktomtea")
    public suspend fun sku(argument: suspend IntegrationAccountSkuArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationAccountSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The workflow state.
     */
    @JvmName("gujsqxhvrivfrygb")
    public suspend fun state(`value`: Either<String, WorkflowState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The workflow state.
     */
    @JvmName("uuapaicvhyriwnso")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WorkflowState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The workflow state.
     */
    @JvmName("hcdarggvsixjpbtu")
    public fun state(`value`: WorkflowState) {
        val toBeMapped = Either.ofRight<String, WorkflowState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("iebwleolwcthiwxl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("lwgwmpqosadilwft")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IntegrationAccountArgs = IntegrationAccountArgs(
        integrationAccountName = integrationAccountName,
        integrationServiceEnvironment = integrationServiceEnvironment,
        location = location,
        resourceGroupName = resourceGroupName,
        sku = sku,
        state = state,
        tags = tags,
    )
}
