@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.IntegrationAccountMapArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.MapType
import com.pulumi.azurenative.logic.kotlin.inputs.IntegrationAccountMapPropertiesParametersSchemaArgs
import com.pulumi.azurenative.logic.kotlin.inputs.IntegrationAccountMapPropertiesParametersSchemaArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The integration account map.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2015-08-01-preview.
 * ## Example Usage
 * ### Create or update a map
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationAccountMap = new AzureNative.Logic.IntegrationAccountMap("integrationAccountMap", new()
 *     {
 *         Content = @"<?xml version=""1.0"" encoding=""UTF-16""?>
 * <xsl:stylesheet xmlns:xsl=""http://www.w3.org/1999/XSL/Transform"" xmlns:msxsl=""urn:schemas-microsoft-com:xslt"" xmlns:var=""http://schemas.microsoft.com/BizTalk/2003/var"" exclude-result-prefixes=""msxsl var s0 userCSharp"" version=""1.0"" xmlns:ns0=""http://BizTalk_Server_Project4.StringFunctoidsDestinationSchema"" xmlns:s0=""http://BizTalk_Server_Project4.StringFunctoidsSourceSchema"" xmlns:userCSharp=""http://schemas.microsoft.com/BizTalk/2003/userCSharp"">
 *   <xsl:import href=""http://btsfunctoids.blob.core.windows.net/functoids/functoids.xslt"" />
 *   <xsl:output omit-xml-declaration=""yes"" method=""xml"" version=""1.0"" />
 *   <xsl:template match=""/"">
 *     <xsl:apply-templates select=""/s0:Root"" />
 *   </xsl:template>
 *   <xsl:template match=""/s0:Root"">
 *     <xsl:variable name=""var:v1"" select=""userCSharp:StringFind(string(StringFindSource/text()) , &quot;SearchString&quot;)"" />
 *     <xsl:variable name=""var:v2"" select=""userCSharp:StringLeft(string(StringLeftSource/text()) , &quot;2&quot;)"" />
 *     <xsl:variable name=""var:v3"" select=""userCSharp:StringRight(string(StringRightSource/text()) , &quot;2&quot;)"" />
 *     <xsl:variable name=""var:v4"" select=""userCSharp:StringUpperCase(string(UppercaseSource/text()))"" />
 *     <xsl:variable name=""var:v5"" select=""userCSharp:StringLowerCase(string(LowercaseSource/text()))"" />
 *     <xsl:variable name=""var:v6"" select=""userCSharp:StringSize(string(SizeSource/text()))"" />
 *     <xsl:variable name=""var:v7"" select=""userCSharp:StringSubstring(string(StringExtractSource/text()) , &quot;0&quot; , &quot;2&quot;)"" />
 *     <xsl:variable name=""var:v8"" select=""userCSharp:StringConcat(string(StringConcatSource/text()))"" />
 *     <xsl:variable name=""var:v9"" select=""userCSharp:StringTrimLeft(string(StringLeftTrimSource/text()))"" />
 *     <xsl:variable name=""var:v10"" select=""userCSharp:StringTrimRight(string(StringRightTrimSource/text()))"" />
 *     <ns0:Root>
 *       <StringFindDestination>
 *         <xsl:value-of select=""$var:v1"" />
 *       </StringFindDestination>
 *       <StringLeftDestination>
 *         <xsl:value-of select=""$var:v2"" />
 *       </StringLeftDestination>
 *       <StringRightDestination>
 *         <xsl:value-of select=""$var:v3"" />
 *       </StringRightDestination>
 *       <UppercaseDestination>
 *         <xsl:value-of select=""$var:v4"" />
 *       </UppercaseDestination>
 *       <LowercaseDestination>
 *         <xsl:value-of select=""$var:v5"" />
 *       </LowercaseDestination>
 *       <SizeDestination>
 *         <xsl:value-of select=""$var:v6"" />
 *       </SizeDestination>
 *       <StringExtractDestination>
 *         <xsl:value-of select=""$var:v7"" />
 *       </StringExtractDestination>
 *       <StringConcatDestination>
 *         <xsl:value-of select=""$var:v8"" />
 *       </StringConcatDestination>
 *       <StringLeftTrimDestination>
 *         <xsl:value-of select=""$var:v9"" />
 *       </StringLeftTrimDestination>
 *       <StringRightTrimDestination>
 *         <xsl:value-of select=""$var:v10"" />
 *       </StringRightTrimDestination>
 *     </ns0:Root>
 *   </xsl:template>
 * </xsl:stylesheet>",
 *         ContentType = "application/xml",
 *         IntegrationAccountName = "testIntegrationAccount",
 *         Location = "westus",
 *         MapName = "testMap",
 *         MapType = AzureNative.Logic.MapType.Xslt,
 *         Metadata = null,
 *         ResourceGroupName = "testResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewIntegrationAccountMap(ctx, "integrationAccountMap", &logic.IntegrationAccountMapArgs{
 * 			Content: pulumi.String(`<?xml version="1.0" encoding="UTF-16"?>
 * <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:var="http://schemas.microsoft.com/BizTalk/2003/var" exclude-result-prefixes="msxsl var s0 userCSharp" version="1.0" xmlns:ns0="http://BizTalk_Server_Project4.StringFunctoidsDestinationSchema" xmlns:s0="http://BizTalk_Server_Project4.StringFunctoidsSourceSchema" xmlns:userCSharp="http://schemas.microsoft.com/BizTalk/2003/userCSharp">
 *   <xsl:import href="http://btsfunctoids.blob.core.windows.net/functoids/functoids.xslt" />
 *   <xsl:output omit-xml-declaration="yes" method="xml" version="1.0" />
 *   <xsl:template match="/">
 *     <xsl:apply-templates select="/s0:Root" />
 *   </xsl:template>
 *   <xsl:template match="/s0:Root">
 *     <xsl:variable name="var:v1" select="userCSharp:StringFind(string(StringFindSource/text()) , &quot;SearchString&quot;)" />
 *     <xsl:variable name="var:v2" select="userCSharp:StringLeft(string(StringLeftSource/text()) , &quot;2&quot;)" />
 *     <xsl:variable name="var:v3" select="userCSharp:StringRight(string(StringRightSource/text()) , &quot;2&quot;)" />
 *     <xsl:variable name="var:v4" select="userCSharp:StringUpperCase(string(UppercaseSource/text()))" />
 *     <xsl:variable name="var:v5" select="userCSharp:StringLowerCase(string(LowercaseSource/text()))" />
 *     <xsl:variable name="var:v6" select="userCSharp:StringSize(string(SizeSource/text()))" />
 *     <xsl:variable name="var:v7" select="userCSharp:StringSubstring(string(StringExtractSource/text()) , &quot;0&quot; , &quot;2&quot;)" />
 *     <xsl:variable name="var:v8" select="userCSharp:StringConcat(string(StringConcatSource/text()))" />
 *     <xsl:variable name="var:v9" select="userCSharp:StringTrimLeft(string(StringLeftTrimSource/text()))" />
 *     <xsl:variable name="var:v10" select="userCSharp:StringTrimRight(string(StringRightTrimSource/text()))" />
 *     <ns0:Root>
 *       <StringFindDestination>
 *         <xsl:value-of select="$var:v1" />
 *       </StringFindDestination>
 *       <StringLeftDestination>
 *         <xsl:value-of select="$var:v2" />
 *       </StringLeftDestination>
 *       <StringRightDestination>
 *         <xsl:value-of select="$var:v3" />
 *       </StringRightDestination>
 *       <UppercaseDestination>
 *         <xsl:value-of select="$var:v4" />
 *       </UppercaseDestination>
 *       <LowercaseDestination>
 *         <xsl:value-of select="$var:v5" />
 *       </LowercaseDestination>
 *       <SizeDestination>
 *         <xsl:value-of select="$var:v6" />
 *       </SizeDestination>
 *       <StringExtractDestination>
 *         <xsl:value-of select="$var:v7" />
 *       </StringExtractDestination>
 *       <StringConcatDestination>
 *         <xsl:value-of select="$var:v8" />
 *       </StringConcatDestination>
 *       <StringLeftTrimDestination>
 *         <xsl:value-of select="$var:v9" />
 *       </StringLeftTrimDestination>
 *       <StringRightTrimDestination>
 *         <xsl:value-of select="$var:v10" />
 *       </StringRightTrimDestination>
 *     </ns0:Root>
 *   </xsl:template>
 * </xsl:stylesheet>`),
 * 			ContentType:            pulumi.String("application/xml"),
 * 			IntegrationAccountName: pulumi.String("testIntegrationAccount"),
 * 			Location:               pulumi.String("westus"),
 * 			MapName:                pulumi.String("testMap"),
 * 			MapType:                pulumi.String(logic.MapTypeXslt),
 * 			Metadata:               pulumi.Any(nil),
 * 			ResourceGroupName:      pulumi.String("testResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationAccountMap;
 * import com.pulumi.azurenative.logic.IntegrationAccountMapArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationAccountMap = new IntegrationAccountMap("integrationAccountMap", IntegrationAccountMapArgs.builder()
 *             .content("""
 * <?xml version="1.0" encoding="UTF-16"?>
 * <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:var="http://schemas.microsoft.com/BizTalk/2003/var" exclude-result-prefixes="msxsl var s0 userCSharp" version="1.0" xmlns:ns0="http://BizTalk_Server_Project4.StringFunctoidsDestinationSchema" xmlns:s0="http://BizTalk_Server_Project4.StringFunctoidsSourceSchema" xmlns:userCSharp="http://schemas.microsoft.com/BizTalk/2003/userCSharp">
 *   <xsl:import href="http://btsfunctoids.blob.core.windows.net/functoids/functoids.xslt" />
 *   <xsl:output omit-xml-declaration="yes" method="xml" version="1.0" />
 *   <xsl:template match="/">
 *     <xsl:apply-templates select="/s0:Root" />
 *   </xsl:template>
 *   <xsl:template match="/s0:Root">
 *     <xsl:variable name="var:v1" select="userCSharp:StringFind(string(StringFindSource/text()) , &quot;SearchString&quot;)" />
 *     <xsl:variable name="var:v2" select="userCSharp:StringLeft(string(StringLeftSource/text()) , &quot;2&quot;)" />
 *     <xsl:variable name="var:v3" select="userCSharp:StringRight(string(StringRightSource/text()) , &quot;2&quot;)" />
 *     <xsl:variable name="var:v4" select="userCSharp:StringUpperCase(string(UppercaseSource/text()))" />
 *     <xsl:variable name="var:v5" select="userCSharp:StringLowerCase(string(LowercaseSource/text()))" />
 *     <xsl:variable name="var:v6" select="userCSharp:StringSize(string(SizeSource/text()))" />
 *     <xsl:variable name="var:v7" select="userCSharp:StringSubstring(string(StringExtractSource/text()) , &quot;0&quot; , &quot;2&quot;)" />
 *     <xsl:variable name="var:v8" select="userCSharp:StringConcat(string(StringConcatSource/text()))" />
 *     <xsl:variable name="var:v9" select="userCSharp:StringTrimLeft(string(StringLeftTrimSource/text()))" />
 *     <xsl:variable name="var:v10" select="userCSharp:StringTrimRight(string(StringRightTrimSource/text()))" />
 *     <ns0:Root>
 *       <StringFindDestination>
 *         <xsl:value-of select="$var:v1" />
 *       </StringFindDestination>
 *       <StringLeftDestination>
 *         <xsl:value-of select="$var:v2" />
 *       </StringLeftDestination>
 *       <StringRightDestination>
 *         <xsl:value-of select="$var:v3" />
 *       </StringRightDestination>
 *       <UppercaseDestination>
 *         <xsl:value-of select="$var:v4" />
 *       </UppercaseDestination>
 *       <LowercaseDestination>
 *         <xsl:value-of select="$var:v5" />
 *       </LowercaseDestination>
 *       <SizeDestination>
 *         <xsl:value-of select="$var:v6" />
 *       </SizeDestination>
 *       <StringExtractDestination>
 *         <xsl:value-of select="$var:v7" />
 *       </StringExtractDestination>
 *       <StringConcatDestination>
 *         <xsl:value-of select="$var:v8" />
 *       </StringConcatDestination>
 *       <StringLeftTrimDestination>
 *         <xsl:value-of select="$var:v9" />
 *       </StringLeftTrimDestination>
 *       <StringRightTrimDestination>
 *         <xsl:value-of select="$var:v10" />
 *       </StringRightTrimDestination>
 *     </ns0:Root>
 *   </xsl:template>
 * </xsl:stylesheet>            """)
 *             .contentType("application/xml")
 *             .integrationAccountName("testIntegrationAccount")
 *             .location("westus")
 *             .mapName("testMap")
 *             .mapType("Xslt")
 *             .metadata()
 *             .resourceGroupName("testResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a map larger than 4 MB
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationAccountMap = new AzureNative.Logic.IntegrationAccountMap("integrationAccountMap", new()
 *     {
 *         ContentType = "application/xml",
 *         IntegrationAccountName = "testIntegrationAccount",
 *         Location = "westus",
 *         MapName = "testMap",
 *         MapType = AzureNative.Logic.MapType.Xslt,
 *         Metadata = null,
 *         ResourceGroupName = "testResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewIntegrationAccountMap(ctx, "integrationAccountMap", &logic.IntegrationAccountMapArgs{
 * 			ContentType:            pulumi.String("application/xml"),
 * 			IntegrationAccountName: pulumi.String("testIntegrationAccount"),
 * 			Location:               pulumi.String("westus"),
 * 			MapName:                pulumi.String("testMap"),
 * 			MapType:                pulumi.String(logic.MapTypeXslt),
 * 			Metadata:               pulumi.Any(nil),
 * 			ResourceGroupName:      pulumi.String("testResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationAccountMap;
 * import com.pulumi.azurenative.logic.IntegrationAccountMapArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationAccountMap = new IntegrationAccountMap("integrationAccountMap", IntegrationAccountMapArgs.builder()
 *             .contentType("application/xml")
 *             .integrationAccountName("testIntegrationAccount")
 *             .location("westus")
 *             .mapName("testMap")
 *             .mapType("Xslt")
 *             .metadata()
 *             .resourceGroupName("testResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationAccountMap testMap /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/maps/{mapName}
 * ```
 * @property content The content.
 * @property contentType The content type.
 * @property integrationAccountName The integration account name.
 * @property location The resource location.
 * @property mapName The integration account map name.
 * @property mapType The map type.
 * @property metadata The metadata.
 * @property parametersSchema The parameters schema of integration account map.
 * @property resourceGroupName The resource group name.
 * @property tags The resource tags.
 */
public data class IntegrationAccountMapArgs(
    public val content: Output<String>? = null,
    public val contentType: Output<String>? = null,
    public val integrationAccountName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val mapName: Output<String>? = null,
    public val mapType: Output<Either<String, MapType>>? = null,
    public val metadata: Output<Any>? = null,
    public val parametersSchema: Output<IntegrationAccountMapPropertiesParametersSchemaArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.IntegrationAccountMapArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.IntegrationAccountMapArgs =
        com.pulumi.azurenative.logic.IntegrationAccountMapArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .integrationAccountName(integrationAccountName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mapName(mapName?.applyValue({ args0 -> args0 }))
            .mapType(
                mapType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .parametersSchema(parametersSchema?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IntegrationAccountMapArgs].
 */
@PulumiTagMarker
public class IntegrationAccountMapArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var contentType: Output<String>? = null

    private var integrationAccountName: Output<String>? = null

    private var location: Output<String>? = null

    private var mapName: Output<String>? = null

    private var mapType: Output<Either<String, MapType>>? = null

    private var metadata: Output<Any>? = null

    private var parametersSchema: Output<IntegrationAccountMapPropertiesParametersSchemaArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The content.
     */
    @JvmName("rctmydkadoarpfhc")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The content type.
     */
    @JvmName("jnfieixvpiirvsjd")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("tlbfjgnmnrtoldfo")
    public suspend fun integrationAccountName(`value`: Output<String>) {
        this.integrationAccountName = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("ikilparylcqpsxsm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The integration account map name.
     */
    @JvmName("cfmcnkaqftikrund")
    public suspend fun mapName(`value`: Output<String>) {
        this.mapName = value
    }

    /**
     * @param value The map type.
     */
    @JvmName("ugoymccpdhrhyjay")
    public suspend fun mapType(`value`: Output<Either<String, MapType>>) {
        this.mapType = value
    }

    /**
     * @param value The metadata.
     */
    @JvmName("drwfrtfpnmghiwgi")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The parameters schema of integration account map.
     */
    @JvmName("veljxedsfoiueeto")
    public suspend fun parametersSchema(`value`: Output<IntegrationAccountMapPropertiesParametersSchemaArgs>) {
        this.parametersSchema = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("bhdqnwowtxxbmgfa")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("lttmgooypgydfmon")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The content.
     */
    @JvmName("tkggdhrvjgsviaxj")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The content type.
     */
    @JvmName("xldsrkvvqcpvjwfn")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("oeibgyferrdaiqlu")
    public suspend fun integrationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("gpwhghhlffokpojm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The integration account map name.
     */
    @JvmName("vvhribddcpnrodfw")
    public suspend fun mapName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mapName = mapped
    }

    /**
     * @param value The map type.
     */
    @JvmName("sjgprvhmegibuabd")
    public suspend fun mapType(`value`: Either<String, MapType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mapType = mapped
    }

    /**
     * @param value The map type.
     */
    @JvmName("sqlswqjphbxhlkqa")
    public fun mapType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MapType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mapType = mapped
    }

    /**
     * @param value The map type.
     */
    @JvmName("sgwtoiwqoirfhssp")
    public fun mapType(`value`: MapType) {
        val toBeMapped = Either.ofRight<String, MapType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mapType = mapped
    }

    /**
     * @param value The metadata.
     */
    @JvmName("wvmtypvogopoeqwd")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The parameters schema of integration account map.
     */
    @JvmName("doexeqrdboknaucm")
    public suspend fun parametersSchema(`value`: IntegrationAccountMapPropertiesParametersSchemaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parametersSchema = mapped
    }

    /**
     * @param argument The parameters schema of integration account map.
     */
    @JvmName("umtutunprtaaroum")
    public suspend fun parametersSchema(argument: suspend IntegrationAccountMapPropertiesParametersSchemaArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationAccountMapPropertiesParametersSchemaArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parametersSchema = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("jfkcfgchytqrjxgx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("hhnnmjibvgrgwleu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("obtewjrmtuaabipv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IntegrationAccountMapArgs = IntegrationAccountMapArgs(
        content = content,
        contentType = contentType,
        integrationAccountName = integrationAccountName,
        location = location,
        mapName = mapName,
        mapType = mapType,
        metadata = metadata,
        parametersSchema = parametersSchema,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
