@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.IntegrationAccountSessionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The integration account session.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * ## Example Usage
 * ### Create or update an integration account session
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationAccountSession = new AzureNative.Logic.IntegrationAccountSession("integrationAccountSession", new()
 *     {
 *         Content = new Dictionary<string, object?>
 *         {
 *             ["controlNumber"] = "1234",
 *             ["controlNumberChangedTime"] = "2017-02-21T22:30:11.9923759Z",
 *         },
 *         IntegrationAccountName = "testia123",
 *         ResourceGroupName = "testrg123",
 *         SessionName = "testsession123-ICN",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewIntegrationAccountSession(ctx, "integrationAccountSession", &logic.IntegrationAccountSessionArgs{
 * 			Content: pulumi.Any(map[string]interface{}{
 * 				"controlNumber":            "1234",
 * 				"controlNumberChangedTime": "2017-02-21T22:30:11.9923759Z",
 * 			}),
 * 			IntegrationAccountName: pulumi.String("testia123"),
 * 			ResourceGroupName:      pulumi.String("testrg123"),
 * 			SessionName:            pulumi.String("testsession123-ICN"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationAccountSession;
 * import com.pulumi.azurenative.logic.IntegrationAccountSessionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationAccountSession = new IntegrationAccountSession("integrationAccountSession", IntegrationAccountSessionArgs.builder()
 *             .content(Map.ofEntries(
 *                 Map.entry("controlNumber", "1234"),
 *                 Map.entry("controlNumberChangedTime", "2017-02-21T22:30:11.9923759Z")
 *             ))
 *             .integrationAccountName("testia123")
 *             .resourceGroupName("testrg123")
 *             .sessionName("testsession123-ICN")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationAccountSession testsession123-ICN /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/sessions/{sessionName}
 * ```
 * @property content The session content.
 * @property integrationAccountName The integration account name.
 * @property location The resource location.
 * @property resourceGroupName The resource group name.
 * @property sessionName The integration account session name.
 * @property tags The resource tags.
 */
public data class IntegrationAccountSessionArgs(
    public val content: Output<Any>? = null,
    public val integrationAccountName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sessionName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.IntegrationAccountSessionArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.IntegrationAccountSessionArgs =
        com.pulumi.azurenative.logic.IntegrationAccountSessionArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .integrationAccountName(integrationAccountName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sessionName(sessionName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IntegrationAccountSessionArgs].
 */
@PulumiTagMarker
public class IntegrationAccountSessionArgsBuilder internal constructor() {
    private var content: Output<Any>? = null

    private var integrationAccountName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sessionName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The session content.
     */
    @JvmName("vxkgugklslasoxlb")
    public suspend fun content(`value`: Output<Any>) {
        this.content = value
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("eulfhqkgvirlhylb")
    public suspend fun integrationAccountName(`value`: Output<String>) {
        this.integrationAccountName = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("oubgbxjirijmulgp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("tiymfaenstyoapld")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The integration account session name.
     */
    @JvmName("pdhqkltqppxsdhos")
    public suspend fun sessionName(`value`: Output<String>) {
        this.sessionName = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("ctbtyeyykpylxscx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The session content.
     */
    @JvmName("kxxhnixisjstxnhi")
    public suspend fun content(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("jkfirlisijqfgqwo")
    public suspend fun integrationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("nloudmviednvuomq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("srfajrbewcdhnyha")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The integration account session name.
     */
    @JvmName("itawmuvmhaxwybsm")
    public suspend fun sessionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionName = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("egextuglgmmrrrvl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("wifrjcndvfpyxbrc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IntegrationAccountSessionArgs = IntegrationAccountSessionArgs(
        content = content,
        integrationAccountName = integrationAccountName,
        location = location,
        resourceGroupName = resourceGroupName,
        sessionName = sessionName,
        tags = tags,
    )
}
