@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.kotlin.outputs.ApiResourceBackendServiceResponse
import com.pulumi.azurenative.logic.kotlin.outputs.ApiResourceDefinitionsResponse
import com.pulumi.azurenative.logic.kotlin.outputs.ApiResourceGeneralInformationResponse
import com.pulumi.azurenative.logic.kotlin.outputs.ApiResourceMetadataResponse
import com.pulumi.azurenative.logic.kotlin.outputs.ApiResourcePoliciesResponse
import com.pulumi.azurenative.logic.kotlin.outputs.IntegrationServiceEnvironmentManagedApiDeploymentParametersResponse
import com.pulumi.azurenative.logic.kotlin.outputs.ResourceReferenceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.logic.kotlin.outputs.ApiResourceBackendServiceResponse.Companion.toKotlin as apiResourceBackendServiceResponseToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ApiResourceDefinitionsResponse.Companion.toKotlin as apiResourceDefinitionsResponseToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ApiResourceGeneralInformationResponse.Companion.toKotlin as apiResourceGeneralInformationResponseToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ApiResourceMetadataResponse.Companion.toKotlin as apiResourceMetadataResponseToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ApiResourcePoliciesResponse.Companion.toKotlin as apiResourcePoliciesResponseToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.IntegrationServiceEnvironmentManagedApiDeploymentParametersResponse.Companion.toKotlin as integrationServiceEnvironmentManagedApiDeploymentParametersResponseToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin as resourceReferenceResponseToKotlin

/**
 * Builder for [IntegrationServiceEnvironmentManagedApi].
 */
@PulumiTagMarker
public class IntegrationServiceEnvironmentManagedApiResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationServiceEnvironmentManagedApiArgs =
        IntegrationServiceEnvironmentManagedApiArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationServiceEnvironmentManagedApiArgsBuilder.() -> Unit) {
        val builder = IntegrationServiceEnvironmentManagedApiArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IntegrationServiceEnvironmentManagedApi {
        val builtJavaResource =
            com.pulumi.azurenative.logic.IntegrationServiceEnvironmentManagedApi(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IntegrationServiceEnvironmentManagedApi(builtJavaResource)
    }
}

/**
 * The integration service environment managed api.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * ## Example Usage
 * ### Gets the integration service environment managed Apis
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationServiceEnvironmentManagedApi = new AzureNative.Logic.IntegrationServiceEnvironmentManagedApi("integrationServiceEnvironmentManagedApi", new()
 *     {
 *         ApiName = "servicebus",
 *         IntegrationServiceEnvironmentName = "testIntegrationServiceEnvironment",
 *         Location = "brazilsouth",
 *         ResourceGroup = "testResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewIntegrationServiceEnvironmentManagedApi(ctx, "integrationServiceEnvironmentManagedApi", &logic.IntegrationServiceEnvironmentManagedApiArgs{
 * 			ApiName:                           pulumi.String("servicebus"),
 * 			IntegrationServiceEnvironmentName: pulumi.String("testIntegrationServiceEnvironment"),
 * 			Location:                          pulumi.String("brazilsouth"),
 * 			ResourceGroup:                     pulumi.String("testResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationServiceEnvironmentManagedApi;
 * import com.pulumi.azurenative.logic.IntegrationServiceEnvironmentManagedApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationServiceEnvironmentManagedApi = new IntegrationServiceEnvironmentManagedApi("integrationServiceEnvironmentManagedApi", IntegrationServiceEnvironmentManagedApiArgs.builder()
 *             .apiName("servicebus")
 *             .integrationServiceEnvironmentName("testIntegrationServiceEnvironment")
 *             .location("brazilsouth")
 *             .resourceGroup("testResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationServiceEnvironmentManagedApi servicebus /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Logic/integrationServiceEnvironments/{integrationServiceEnvironmentName}/managedApis/{apiName}
 * ```
 */
public class IntegrationServiceEnvironmentManagedApi internal constructor(
    override val javaResource: com.pulumi.azurenative.logic.IntegrationServiceEnvironmentManagedApi,
) : KotlinCustomResource(javaResource, IntegrationServiceEnvironmentManagedApiMapper) {
    /**
     * The API definition.
     */
    public val apiDefinitionUrl: Output<String>
        get() = javaResource.apiDefinitionUrl().applyValue({ args0 -> args0 })

    /**
     * The api definitions.
     */
    public val apiDefinitions: Output<ApiResourceDefinitionsResponse>
        get() = javaResource.apiDefinitions().applyValue({ args0 ->
            args0.let({ args0 ->
                apiResourceDefinitionsResponseToKotlin(args0)
            })
        })

    /**
     * The backend service.
     */
    public val backendService: Output<ApiResourceBackendServiceResponse>
        get() = javaResource.backendService().applyValue({ args0 ->
            args0.let({ args0 ->
                apiResourceBackendServiceResponseToKotlin(args0)
            })
        })

    /**
     * The capabilities.
     */
    public val capabilities: Output<List<String>>
        get() = javaResource.capabilities().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The category.
     */
    public val category: Output<String>
        get() = javaResource.category().applyValue({ args0 -> args0 })

    /**
     * The connection parameters.
     */
    public val connectionParameters: Output<Map<String, Any>>
        get() = javaResource.connectionParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The integration service environment managed api deployment parameters.
     */
    public val deploymentParameters:
        Output<IntegrationServiceEnvironmentManagedApiDeploymentParametersResponse>?
        get() = javaResource.deploymentParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    integrationServiceEnvironmentManagedApiDeploymentParametersResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The api general information.
     */
    public val generalInformation: Output<ApiResourceGeneralInformationResponse>
        get() = javaResource.generalInformation().applyValue({ args0 ->
            args0.let({ args0 ->
                apiResourceGeneralInformationResponseToKotlin(args0)
            })
        })

    /**
     * The integration service environment reference.
     */
    public val integrationServiceEnvironment: Output<ResourceReferenceResponse>?
        get() = javaResource.integrationServiceEnvironment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resourceReferenceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The metadata.
     */
    public val metadata: Output<ApiResourceMetadataResponse>
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.let({ args0 ->
                apiResourceMetadataResponseToKotlin(args0)
            })
        })

    /**
     * Gets the resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The policies for the API.
     */
    public val policies: Output<ApiResourcePoliciesResponse>
        get() = javaResource.policies().applyValue({ args0 ->
            args0.let({ args0 ->
                apiResourcePoliciesResponseToKotlin(args0)
            })
        })

    /**
     * The provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The runtime urls.
     */
    public val runtimeUrls: Output<List<String>>
        get() = javaResource.runtimeUrls().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets the resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IntegrationServiceEnvironmentManagedApiMapper :
    ResourceMapper<IntegrationServiceEnvironmentManagedApi> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.logic.IntegrationServiceEnvironmentManagedApi::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationServiceEnvironmentManagedApi =
        IntegrationServiceEnvironmentManagedApi(
            javaResource as
                com.pulumi.azurenative.logic.IntegrationServiceEnvironmentManagedApi,
        )
}

/**
 * @see [IntegrationServiceEnvironmentManagedApi].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationServiceEnvironmentManagedApi].
 */
public suspend fun integrationServiceEnvironmentManagedApi(
    name: String,
    block: suspend IntegrationServiceEnvironmentManagedApiResourceBuilder.() -> Unit,
): IntegrationServiceEnvironmentManagedApi {
    val builder = IntegrationServiceEnvironmentManagedApiResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationServiceEnvironmentManagedApi].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationServiceEnvironmentManagedApi(name: String): IntegrationServiceEnvironmentManagedApi {
    val builder = IntegrationServiceEnvironmentManagedApiResourceBuilder()
    builder.name(name)
    return builder.build()
}
