@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.LogicFunctions.getIntegrationAccountAgreementPlain
import com.pulumi.azurenative.logic.LogicFunctions.getIntegrationAccountAssemblyPlain
import com.pulumi.azurenative.logic.LogicFunctions.getIntegrationAccountBatchConfigurationPlain
import com.pulumi.azurenative.logic.LogicFunctions.getIntegrationAccountCertificatePlain
import com.pulumi.azurenative.logic.LogicFunctions.getIntegrationAccountMapPlain
import com.pulumi.azurenative.logic.LogicFunctions.getIntegrationAccountPartnerPlain
import com.pulumi.azurenative.logic.LogicFunctions.getIntegrationAccountPlain
import com.pulumi.azurenative.logic.LogicFunctions.getIntegrationAccountSchemaPlain
import com.pulumi.azurenative.logic.LogicFunctions.getIntegrationAccountSessionPlain
import com.pulumi.azurenative.logic.LogicFunctions.getIntegrationServiceEnvironmentManagedApiPlain
import com.pulumi.azurenative.logic.LogicFunctions.getIntegrationServiceEnvironmentPlain
import com.pulumi.azurenative.logic.LogicFunctions.getRosettaNetProcessConfigurationPlain
import com.pulumi.azurenative.logic.LogicFunctions.getWorkflowAccessKeyPlain
import com.pulumi.azurenative.logic.LogicFunctions.getWorkflowPlain
import com.pulumi.azurenative.logic.LogicFunctions.listIntegrationAccountAgreementContentCallbackUrlPlain
import com.pulumi.azurenative.logic.LogicFunctions.listIntegrationAccountAssemblyContentCallbackUrlPlain
import com.pulumi.azurenative.logic.LogicFunctions.listIntegrationAccountCallbackUrlPlain
import com.pulumi.azurenative.logic.LogicFunctions.listIntegrationAccountKeyVaultKeysPlain
import com.pulumi.azurenative.logic.LogicFunctions.listIntegrationAccountMapContentCallbackUrlPlain
import com.pulumi.azurenative.logic.LogicFunctions.listIntegrationAccountPartnerContentCallbackUrlPlain
import com.pulumi.azurenative.logic.LogicFunctions.listIntegrationAccountSchemaContentCallbackUrlPlain
import com.pulumi.azurenative.logic.LogicFunctions.listWorkflowAccessKeySecretKeysPlain
import com.pulumi.azurenative.logic.LogicFunctions.listWorkflowCallbackUrlPlain
import com.pulumi.azurenative.logic.LogicFunctions.listWorkflowRunActionExpressionTracesPlain
import com.pulumi.azurenative.logic.LogicFunctions.listWorkflowRunActionRepetitionExpressionTracesPlain
import com.pulumi.azurenative.logic.LogicFunctions.listWorkflowTriggerCallbackUrlPlain
import com.pulumi.azurenative.logic.LogicFunctions.listWorkflowVersionCallbackUrlPlain
import com.pulumi.azurenative.logic.LogicFunctions.listWorkflowVersionTriggerCallbackUrlPlain
import com.pulumi.azurenative.logic.kotlin.enums.KeyType
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationAccountAgreementPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationAccountAgreementPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationAccountAssemblyPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationAccountAssemblyPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationAccountBatchConfigurationPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationAccountBatchConfigurationPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationAccountCertificatePlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationAccountCertificatePlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationAccountMapPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationAccountMapPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationAccountPartnerPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationAccountPartnerPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationAccountPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationAccountPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationAccountSchemaPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationAccountSchemaPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationAccountSessionPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationAccountSessionPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationServiceEnvironmentManagedApiPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationServiceEnvironmentManagedApiPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationServiceEnvironmentPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.GetIntegrationServiceEnvironmentPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.GetRosettaNetProcessConfigurationPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.GetRosettaNetProcessConfigurationPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.GetWorkflowAccessKeyPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.GetWorkflowAccessKeyPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.GetWorkflowPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.GetWorkflowPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.KeyVaultReference
import com.pulumi.azurenative.logic.kotlin.inputs.ListIntegrationAccountAgreementContentCallbackUrlPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.ListIntegrationAccountAgreementContentCallbackUrlPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.ListIntegrationAccountAssemblyContentCallbackUrlPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.ListIntegrationAccountAssemblyContentCallbackUrlPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.ListIntegrationAccountCallbackUrlPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.ListIntegrationAccountCallbackUrlPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.ListIntegrationAccountKeyVaultKeysPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.ListIntegrationAccountKeyVaultKeysPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.ListIntegrationAccountMapContentCallbackUrlPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.ListIntegrationAccountMapContentCallbackUrlPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.ListIntegrationAccountPartnerContentCallbackUrlPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.ListIntegrationAccountPartnerContentCallbackUrlPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.ListIntegrationAccountSchemaContentCallbackUrlPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.ListIntegrationAccountSchemaContentCallbackUrlPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.ListWorkflowAccessKeySecretKeysPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.ListWorkflowAccessKeySecretKeysPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.ListWorkflowCallbackUrlPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.ListWorkflowCallbackUrlPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.ListWorkflowRunActionExpressionTracesPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.ListWorkflowRunActionExpressionTracesPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.ListWorkflowRunActionRepetitionExpressionTracesPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.ListWorkflowRunActionRepetitionExpressionTracesPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.ListWorkflowTriggerCallbackUrlPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.ListWorkflowTriggerCallbackUrlPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.ListWorkflowVersionCallbackUrlPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.ListWorkflowVersionCallbackUrlPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.ListWorkflowVersionTriggerCallbackUrlPlainArgs
import com.pulumi.azurenative.logic.kotlin.inputs.ListWorkflowVersionTriggerCallbackUrlPlainArgsBuilder
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationAccountAgreementResult
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationAccountAssemblyResult
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationAccountBatchConfigurationResult
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationAccountCertificateResult
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationAccountMapResult
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationAccountPartnerResult
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationAccountResult
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationAccountSchemaResult
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationAccountSessionResult
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationServiceEnvironmentManagedApiResult
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationServiceEnvironmentResult
import com.pulumi.azurenative.logic.kotlin.outputs.GetRosettaNetProcessConfigurationResult
import com.pulumi.azurenative.logic.kotlin.outputs.GetWorkflowAccessKeyResult
import com.pulumi.azurenative.logic.kotlin.outputs.GetWorkflowResult
import com.pulumi.azurenative.logic.kotlin.outputs.ListIntegrationAccountAgreementContentCallbackUrlResult
import com.pulumi.azurenative.logic.kotlin.outputs.ListIntegrationAccountAssemblyContentCallbackUrlResult
import com.pulumi.azurenative.logic.kotlin.outputs.ListIntegrationAccountCallbackUrlResult
import com.pulumi.azurenative.logic.kotlin.outputs.ListIntegrationAccountKeyVaultKeysResult
import com.pulumi.azurenative.logic.kotlin.outputs.ListIntegrationAccountMapContentCallbackUrlResult
import com.pulumi.azurenative.logic.kotlin.outputs.ListIntegrationAccountPartnerContentCallbackUrlResult
import com.pulumi.azurenative.logic.kotlin.outputs.ListIntegrationAccountSchemaContentCallbackUrlResult
import com.pulumi.azurenative.logic.kotlin.outputs.ListWorkflowAccessKeySecretKeysResult
import com.pulumi.azurenative.logic.kotlin.outputs.ListWorkflowCallbackUrlResult
import com.pulumi.azurenative.logic.kotlin.outputs.ListWorkflowRunActionExpressionTracesResult
import com.pulumi.azurenative.logic.kotlin.outputs.ListWorkflowRunActionRepetitionExpressionTracesResult
import com.pulumi.azurenative.logic.kotlin.outputs.ListWorkflowTriggerCallbackUrlResult
import com.pulumi.azurenative.logic.kotlin.outputs.ListWorkflowVersionCallbackUrlResult
import com.pulumi.azurenative.logic.kotlin.outputs.ListWorkflowVersionTriggerCallbackUrlResult
import com.pulumi.core.Either
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationAccountAgreementResult.Companion.toKotlin as getIntegrationAccountAgreementResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationAccountAssemblyResult.Companion.toKotlin as getIntegrationAccountAssemblyResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationAccountBatchConfigurationResult.Companion.toKotlin as getIntegrationAccountBatchConfigurationResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationAccountCertificateResult.Companion.toKotlin as getIntegrationAccountCertificateResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationAccountMapResult.Companion.toKotlin as getIntegrationAccountMapResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationAccountPartnerResult.Companion.toKotlin as getIntegrationAccountPartnerResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationAccountResult.Companion.toKotlin as getIntegrationAccountResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationAccountSchemaResult.Companion.toKotlin as getIntegrationAccountSchemaResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationAccountSessionResult.Companion.toKotlin as getIntegrationAccountSessionResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationServiceEnvironmentManagedApiResult.Companion.toKotlin as getIntegrationServiceEnvironmentManagedApiResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.GetIntegrationServiceEnvironmentResult.Companion.toKotlin as getIntegrationServiceEnvironmentResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.GetRosettaNetProcessConfigurationResult.Companion.toKotlin as getRosettaNetProcessConfigurationResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.GetWorkflowAccessKeyResult.Companion.toKotlin as getWorkflowAccessKeyResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.GetWorkflowResult.Companion.toKotlin as getWorkflowResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ListIntegrationAccountAgreementContentCallbackUrlResult.Companion.toKotlin as listIntegrationAccountAgreementContentCallbackUrlResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ListIntegrationAccountAssemblyContentCallbackUrlResult.Companion.toKotlin as listIntegrationAccountAssemblyContentCallbackUrlResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ListIntegrationAccountCallbackUrlResult.Companion.toKotlin as listIntegrationAccountCallbackUrlResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ListIntegrationAccountKeyVaultKeysResult.Companion.toKotlin as listIntegrationAccountKeyVaultKeysResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ListIntegrationAccountMapContentCallbackUrlResult.Companion.toKotlin as listIntegrationAccountMapContentCallbackUrlResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ListIntegrationAccountPartnerContentCallbackUrlResult.Companion.toKotlin as listIntegrationAccountPartnerContentCallbackUrlResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ListIntegrationAccountSchemaContentCallbackUrlResult.Companion.toKotlin as listIntegrationAccountSchemaContentCallbackUrlResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ListWorkflowAccessKeySecretKeysResult.Companion.toKotlin as listWorkflowAccessKeySecretKeysResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ListWorkflowCallbackUrlResult.Companion.toKotlin as listWorkflowCallbackUrlResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ListWorkflowRunActionExpressionTracesResult.Companion.toKotlin as listWorkflowRunActionExpressionTracesResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ListWorkflowRunActionRepetitionExpressionTracesResult.Companion.toKotlin as listWorkflowRunActionRepetitionExpressionTracesResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ListWorkflowTriggerCallbackUrlResult.Companion.toKotlin as listWorkflowTriggerCallbackUrlResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ListWorkflowVersionCallbackUrlResult.Companion.toKotlin as listWorkflowVersionCallbackUrlResultToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ListWorkflowVersionTriggerCallbackUrlResult.Companion.toKotlin as listWorkflowVersionTriggerCallbackUrlResultToKotlin

public object LogicFunctions {
    /**
     * Gets an integration account.
     * Azure REST API version: 2019-05-01.
     * Other available API versions: 2015-08-01-preview.
     * @param argument null
     * @return The integration account.
     */
    public suspend fun getIntegrationAccount(argument: GetIntegrationAccountPlainArgs): GetIntegrationAccountResult =
        getIntegrationAccountResultToKotlin(getIntegrationAccountPlain(argument.toJava()).await())

    /**
     * @see [getIntegrationAccount].
     * @param integrationAccountName The integration account name.
     * @param resourceGroupName The resource group name.
     * @return The integration account.
     */
    public suspend fun getIntegrationAccount(
        integrationAccountName: String,
        resourceGroupName: String,
    ): GetIntegrationAccountResult {
        val argument = GetIntegrationAccountPlainArgs(
            integrationAccountName = integrationAccountName,
            resourceGroupName = resourceGroupName,
        )
        return getIntegrationAccountResultToKotlin(getIntegrationAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;GetIntegrationAccountPlainArgs].
     * @return The integration account.
     */
    public suspend fun getIntegrationAccount(argument: suspend GetIntegrationAccountPlainArgsBuilder.() -> Unit): GetIntegrationAccountResult {
        val builder = GetIntegrationAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationAccountResultToKotlin(getIntegrationAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an integration account agreement.
     * Azure REST API version: 2019-05-01.
     * Other available API versions: 2015-08-01-preview.
     * @param argument null
     * @return The integration account agreement.
     */
    public suspend fun getIntegrationAccountAgreement(argument: GetIntegrationAccountAgreementPlainArgs): GetIntegrationAccountAgreementResult =
        getIntegrationAccountAgreementResultToKotlin(getIntegrationAccountAgreementPlain(argument.toJava()).await())

    /**
     * @see [getIntegrationAccountAgreement].
     * @param agreementName The integration account agreement name.
     * @param integrationAccountName The integration account name.
     * @param resourceGroupName The resource group name.
     * @return The integration account agreement.
     */
    public suspend fun getIntegrationAccountAgreement(
        agreementName: String,
        integrationAccountName: String,
        resourceGroupName: String,
    ): GetIntegrationAccountAgreementResult {
        val argument = GetIntegrationAccountAgreementPlainArgs(
            agreementName = agreementName,
            integrationAccountName = integrationAccountName,
            resourceGroupName = resourceGroupName,
        )
        return getIntegrationAccountAgreementResultToKotlin(getIntegrationAccountAgreementPlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationAccountAgreement].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;GetIntegrationAccountAgreementPlainArgs].
     * @return The integration account agreement.
     */
    public suspend fun getIntegrationAccountAgreement(argument: suspend GetIntegrationAccountAgreementPlainArgsBuilder.() -> Unit): GetIntegrationAccountAgreementResult {
        val builder = GetIntegrationAccountAgreementPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationAccountAgreementResultToKotlin(getIntegrationAccountAgreementPlain(builtArgument.toJava()).await())
    }

    /**
     * Get an assembly for an integration account.
     * Azure REST API version: 2019-05-01.
     * @param argument null
     * @return The assembly definition.
     */
    public suspend fun getIntegrationAccountAssembly(argument: GetIntegrationAccountAssemblyPlainArgs): GetIntegrationAccountAssemblyResult =
        getIntegrationAccountAssemblyResultToKotlin(getIntegrationAccountAssemblyPlain(argument.toJava()).await())

    /**
     * @see [getIntegrationAccountAssembly].
     * @param assemblyArtifactName The assembly artifact name.
     * @param integrationAccountName The integration account name.
     * @param resourceGroupName The resource group name.
     * @return The assembly definition.
     */
    public suspend fun getIntegrationAccountAssembly(
        assemblyArtifactName: String,
        integrationAccountName: String,
        resourceGroupName: String,
    ): GetIntegrationAccountAssemblyResult {
        val argument = GetIntegrationAccountAssemblyPlainArgs(
            assemblyArtifactName = assemblyArtifactName,
            integrationAccountName = integrationAccountName,
            resourceGroupName = resourceGroupName,
        )
        return getIntegrationAccountAssemblyResultToKotlin(getIntegrationAccountAssemblyPlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationAccountAssembly].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;GetIntegrationAccountAssemblyPlainArgs].
     * @return The assembly definition.
     */
    public suspend fun getIntegrationAccountAssembly(argument: suspend GetIntegrationAccountAssemblyPlainArgsBuilder.() -> Unit): GetIntegrationAccountAssemblyResult {
        val builder = GetIntegrationAccountAssemblyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationAccountAssemblyResultToKotlin(getIntegrationAccountAssemblyPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a batch configuration for an integration account.
     * Azure REST API version: 2019-05-01.
     * @param argument null
     * @return The batch configuration resource definition.
     */
    public suspend fun getIntegrationAccountBatchConfiguration(argument: GetIntegrationAccountBatchConfigurationPlainArgs): GetIntegrationAccountBatchConfigurationResult =
        getIntegrationAccountBatchConfigurationResultToKotlin(getIntegrationAccountBatchConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getIntegrationAccountBatchConfiguration].
     * @param batchConfigurationName The batch configuration name.
     * @param integrationAccountName The integration account name.
     * @param resourceGroupName The resource group name.
     * @return The batch configuration resource definition.
     */
    public suspend fun getIntegrationAccountBatchConfiguration(
        batchConfigurationName: String,
        integrationAccountName: String,
        resourceGroupName: String,
    ): GetIntegrationAccountBatchConfigurationResult {
        val argument = GetIntegrationAccountBatchConfigurationPlainArgs(
            batchConfigurationName = batchConfigurationName,
            integrationAccountName = integrationAccountName,
            resourceGroupName = resourceGroupName,
        )
        return getIntegrationAccountBatchConfigurationResultToKotlin(getIntegrationAccountBatchConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationAccountBatchConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;GetIntegrationAccountBatchConfigurationPlainArgs].
     * @return The batch configuration resource definition.
     */
    public suspend fun getIntegrationAccountBatchConfiguration(argument: suspend GetIntegrationAccountBatchConfigurationPlainArgsBuilder.() -> Unit): GetIntegrationAccountBatchConfigurationResult {
        val builder = GetIntegrationAccountBatchConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationAccountBatchConfigurationResultToKotlin(getIntegrationAccountBatchConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an integration account certificate.
     * Azure REST API version: 2019-05-01.
     * Other available API versions: 2015-08-01-preview.
     * @param argument null
     * @return The integration account certificate.
     */
    public suspend fun getIntegrationAccountCertificate(argument: GetIntegrationAccountCertificatePlainArgs): GetIntegrationAccountCertificateResult =
        getIntegrationAccountCertificateResultToKotlin(getIntegrationAccountCertificatePlain(argument.toJava()).await())

    /**
     * @see [getIntegrationAccountCertificate].
     * @param certificateName The integration account certificate name.
     * @param integrationAccountName The integration account name.
     * @param resourceGroupName The resource group name.
     * @return The integration account certificate.
     */
    public suspend fun getIntegrationAccountCertificate(
        certificateName: String,
        integrationAccountName: String,
        resourceGroupName: String,
    ): GetIntegrationAccountCertificateResult {
        val argument = GetIntegrationAccountCertificatePlainArgs(
            certificateName = certificateName,
            integrationAccountName = integrationAccountName,
            resourceGroupName = resourceGroupName,
        )
        return getIntegrationAccountCertificateResultToKotlin(getIntegrationAccountCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationAccountCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;GetIntegrationAccountCertificatePlainArgs].
     * @return The integration account certificate.
     */
    public suspend fun getIntegrationAccountCertificate(argument: suspend GetIntegrationAccountCertificatePlainArgsBuilder.() -> Unit): GetIntegrationAccountCertificateResult {
        val builder = GetIntegrationAccountCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationAccountCertificateResultToKotlin(getIntegrationAccountCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an integration account map.
     * Azure REST API version: 2019-05-01.
     * Other available API versions: 2015-08-01-preview.
     * @param argument null
     * @return The integration account map.
     */
    public suspend fun getIntegrationAccountMap(argument: GetIntegrationAccountMapPlainArgs): GetIntegrationAccountMapResult =
        getIntegrationAccountMapResultToKotlin(getIntegrationAccountMapPlain(argument.toJava()).await())

    /**
     * @see [getIntegrationAccountMap].
     * @param integrationAccountName The integration account name.
     * @param mapName The integration account map name.
     * @param resourceGroupName The resource group name.
     * @return The integration account map.
     */
    public suspend fun getIntegrationAccountMap(
        integrationAccountName: String,
        mapName: String,
        resourceGroupName: String,
    ): GetIntegrationAccountMapResult {
        val argument = GetIntegrationAccountMapPlainArgs(
            integrationAccountName = integrationAccountName,
            mapName = mapName,
            resourceGroupName = resourceGroupName,
        )
        return getIntegrationAccountMapResultToKotlin(getIntegrationAccountMapPlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationAccountMap].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;GetIntegrationAccountMapPlainArgs].
     * @return The integration account map.
     */
    public suspend fun getIntegrationAccountMap(argument: suspend GetIntegrationAccountMapPlainArgsBuilder.() -> Unit): GetIntegrationAccountMapResult {
        val builder = GetIntegrationAccountMapPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationAccountMapResultToKotlin(getIntegrationAccountMapPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an integration account partner.
     * Azure REST API version: 2019-05-01.
     * Other available API versions: 2015-08-01-preview.
     * @param argument null
     * @return The integration account partner.
     */
    public suspend fun getIntegrationAccountPartner(argument: GetIntegrationAccountPartnerPlainArgs): GetIntegrationAccountPartnerResult =
        getIntegrationAccountPartnerResultToKotlin(getIntegrationAccountPartnerPlain(argument.toJava()).await())

    /**
     * @see [getIntegrationAccountPartner].
     * @param integrationAccountName The integration account name.
     * @param partnerName The integration account partner name.
     * @param resourceGroupName The resource group name.
     * @return The integration account partner.
     */
    public suspend fun getIntegrationAccountPartner(
        integrationAccountName: String,
        partnerName: String,
        resourceGroupName: String,
    ): GetIntegrationAccountPartnerResult {
        val argument = GetIntegrationAccountPartnerPlainArgs(
            integrationAccountName = integrationAccountName,
            partnerName = partnerName,
            resourceGroupName = resourceGroupName,
        )
        return getIntegrationAccountPartnerResultToKotlin(getIntegrationAccountPartnerPlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationAccountPartner].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;GetIntegrationAccountPartnerPlainArgs].
     * @return The integration account partner.
     */
    public suspend fun getIntegrationAccountPartner(argument: suspend GetIntegrationAccountPartnerPlainArgsBuilder.() -> Unit): GetIntegrationAccountPartnerResult {
        val builder = GetIntegrationAccountPartnerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationAccountPartnerResultToKotlin(getIntegrationAccountPartnerPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an integration account schema.
     * Azure REST API version: 2019-05-01.
     * Other available API versions: 2015-08-01-preview.
     * @param argument null
     * @return The integration account schema.
     */
    public suspend fun getIntegrationAccountSchema(argument: GetIntegrationAccountSchemaPlainArgs): GetIntegrationAccountSchemaResult =
        getIntegrationAccountSchemaResultToKotlin(getIntegrationAccountSchemaPlain(argument.toJava()).await())

    /**
     * @see [getIntegrationAccountSchema].
     * @param integrationAccountName The integration account name.
     * @param resourceGroupName The resource group name.
     * @param schemaName The integration account schema name.
     * @return The integration account schema.
     */
    public suspend fun getIntegrationAccountSchema(
        integrationAccountName: String,
        resourceGroupName: String,
        schemaName: String,
    ): GetIntegrationAccountSchemaResult {
        val argument = GetIntegrationAccountSchemaPlainArgs(
            integrationAccountName = integrationAccountName,
            resourceGroupName = resourceGroupName,
            schemaName = schemaName,
        )
        return getIntegrationAccountSchemaResultToKotlin(getIntegrationAccountSchemaPlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationAccountSchema].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;GetIntegrationAccountSchemaPlainArgs].
     * @return The integration account schema.
     */
    public suspend fun getIntegrationAccountSchema(argument: suspend GetIntegrationAccountSchemaPlainArgsBuilder.() -> Unit): GetIntegrationAccountSchemaResult {
        val builder = GetIntegrationAccountSchemaPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationAccountSchemaResultToKotlin(getIntegrationAccountSchemaPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an integration account session.
     * Azure REST API version: 2019-05-01.
     * @param argument null
     * @return The integration account session.
     */
    public suspend fun getIntegrationAccountSession(argument: GetIntegrationAccountSessionPlainArgs): GetIntegrationAccountSessionResult =
        getIntegrationAccountSessionResultToKotlin(getIntegrationAccountSessionPlain(argument.toJava()).await())

    /**
     * @see [getIntegrationAccountSession].
     * @param integrationAccountName The integration account name.
     * @param resourceGroupName The resource group name.
     * @param sessionName The integration account session name.
     * @return The integration account session.
     */
    public suspend fun getIntegrationAccountSession(
        integrationAccountName: String,
        resourceGroupName: String,
        sessionName: String,
    ): GetIntegrationAccountSessionResult {
        val argument = GetIntegrationAccountSessionPlainArgs(
            integrationAccountName = integrationAccountName,
            resourceGroupName = resourceGroupName,
            sessionName = sessionName,
        )
        return getIntegrationAccountSessionResultToKotlin(getIntegrationAccountSessionPlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationAccountSession].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;GetIntegrationAccountSessionPlainArgs].
     * @return The integration account session.
     */
    public suspend fun getIntegrationAccountSession(argument: suspend GetIntegrationAccountSessionPlainArgsBuilder.() -> Unit): GetIntegrationAccountSessionResult {
        val builder = GetIntegrationAccountSessionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationAccountSessionResultToKotlin(getIntegrationAccountSessionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an integration service environment.
     * Azure REST API version: 2019-05-01.
     * @param argument null
     * @return The integration service environment.
     */
    public suspend fun getIntegrationServiceEnvironment(argument: GetIntegrationServiceEnvironmentPlainArgs): GetIntegrationServiceEnvironmentResult =
        getIntegrationServiceEnvironmentResultToKotlin(getIntegrationServiceEnvironmentPlain(argument.toJava()).await())

    /**
     * @see [getIntegrationServiceEnvironment].
     * @param integrationServiceEnvironmentName The integration service environment name.
     * @param resourceGroup The resource group.
     * @return The integration service environment.
     */
    public suspend fun getIntegrationServiceEnvironment(
        integrationServiceEnvironmentName: String,
        resourceGroup: String,
    ): GetIntegrationServiceEnvironmentResult {
        val argument = GetIntegrationServiceEnvironmentPlainArgs(
            integrationServiceEnvironmentName = integrationServiceEnvironmentName,
            resourceGroup = resourceGroup,
        )
        return getIntegrationServiceEnvironmentResultToKotlin(getIntegrationServiceEnvironmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationServiceEnvironment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;GetIntegrationServiceEnvironmentPlainArgs].
     * @return The integration service environment.
     */
    public suspend fun getIntegrationServiceEnvironment(argument: suspend GetIntegrationServiceEnvironmentPlainArgsBuilder.() -> Unit): GetIntegrationServiceEnvironmentResult {
        val builder = GetIntegrationServiceEnvironmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationServiceEnvironmentResultToKotlin(getIntegrationServiceEnvironmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the integration service environment managed Api.
     * Azure REST API version: 2019-05-01.
     * @param argument null
     * @return The integration service environment managed api.
     */
    public suspend fun getIntegrationServiceEnvironmentManagedApi(argument: GetIntegrationServiceEnvironmentManagedApiPlainArgs): GetIntegrationServiceEnvironmentManagedApiResult =
        getIntegrationServiceEnvironmentManagedApiResultToKotlin(getIntegrationServiceEnvironmentManagedApiPlain(argument.toJava()).await())

    /**
     * @see [getIntegrationServiceEnvironmentManagedApi].
     * @param apiName The api name.
     * @param integrationServiceEnvironmentName The integration service environment name.
     * @param resourceGroup The resource group name.
     * @return The integration service environment managed api.
     */
    public suspend fun getIntegrationServiceEnvironmentManagedApi(
        apiName: String,
        integrationServiceEnvironmentName: String,
        resourceGroup: String,
    ): GetIntegrationServiceEnvironmentManagedApiResult {
        val argument = GetIntegrationServiceEnvironmentManagedApiPlainArgs(
            apiName = apiName,
            integrationServiceEnvironmentName = integrationServiceEnvironmentName,
            resourceGroup = resourceGroup,
        )
        return getIntegrationServiceEnvironmentManagedApiResultToKotlin(getIntegrationServiceEnvironmentManagedApiPlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationServiceEnvironmentManagedApi].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;GetIntegrationServiceEnvironmentManagedApiPlainArgs].
     * @return The integration service environment managed api.
     */
    public suspend fun getIntegrationServiceEnvironmentManagedApi(argument: suspend GetIntegrationServiceEnvironmentManagedApiPlainArgsBuilder.() -> Unit): GetIntegrationServiceEnvironmentManagedApiResult {
        val builder = GetIntegrationServiceEnvironmentManagedApiPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationServiceEnvironmentManagedApiResultToKotlin(getIntegrationServiceEnvironmentManagedApiPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an integration account RosettaNetProcessConfiguration.
     * Azure REST API version: 2016-06-01.
     * @param argument null
     * @return The integration account RosettaNet process configuration.
     */
    public suspend fun getRosettaNetProcessConfiguration(argument: GetRosettaNetProcessConfigurationPlainArgs): GetRosettaNetProcessConfigurationResult =
        getRosettaNetProcessConfigurationResultToKotlin(getRosettaNetProcessConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getRosettaNetProcessConfiguration].
     * @param integrationAccountName The integration account name.
     * @param resourceGroupName The resource group name.
     * @param rosettaNetProcessConfigurationName The integration account RosettaNetProcessConfiguration name.
     * @return The integration account RosettaNet process configuration.
     */
    public suspend fun getRosettaNetProcessConfiguration(
        integrationAccountName: String,
        resourceGroupName: String,
        rosettaNetProcessConfigurationName: String,
    ): GetRosettaNetProcessConfigurationResult {
        val argument = GetRosettaNetProcessConfigurationPlainArgs(
            integrationAccountName = integrationAccountName,
            resourceGroupName = resourceGroupName,
            rosettaNetProcessConfigurationName = rosettaNetProcessConfigurationName,
        )
        return getRosettaNetProcessConfigurationResultToKotlin(getRosettaNetProcessConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getRosettaNetProcessConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;GetRosettaNetProcessConfigurationPlainArgs].
     * @return The integration account RosettaNet process configuration.
     */
    public suspend fun getRosettaNetProcessConfiguration(argument: suspend GetRosettaNetProcessConfigurationPlainArgsBuilder.() -> Unit): GetRosettaNetProcessConfigurationResult {
        val builder = GetRosettaNetProcessConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRosettaNetProcessConfigurationResultToKotlin(getRosettaNetProcessConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a workflow.
     * Azure REST API version: 2019-05-01.
     * Other available API versions: 2015-02-01-preview, 2016-06-01, 2018-07-01-preview.
     * @param argument null
     * @return The workflow type.
     */
    public suspend fun getWorkflow(argument: GetWorkflowPlainArgs): GetWorkflowResult =
        getWorkflowResultToKotlin(getWorkflowPlain(argument.toJava()).await())

    /**
     * @see [getWorkflow].
     * @param resourceGroupName The resource group name.
     * @param workflowName The workflow name.
     * @return The workflow type.
     */
    public suspend fun getWorkflow(resourceGroupName: String, workflowName: String): GetWorkflowResult {
        val argument = GetWorkflowPlainArgs(
            resourceGroupName = resourceGroupName,
            workflowName = workflowName,
        )
        return getWorkflowResultToKotlin(getWorkflowPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkflow].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;GetWorkflowPlainArgs].
     * @return The workflow type.
     */
    public suspend fun getWorkflow(argument: suspend GetWorkflowPlainArgsBuilder.() -> Unit): GetWorkflowResult {
        val builder = GetWorkflowPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkflowResultToKotlin(getWorkflowPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a workflow access key.
     * Azure REST API version: 2015-02-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getWorkflowAccessKey(argument: GetWorkflowAccessKeyPlainArgs): GetWorkflowAccessKeyResult =
        getWorkflowAccessKeyResultToKotlin(getWorkflowAccessKeyPlain(argument.toJava()).await())

    /**
     * @see [getWorkflowAccessKey].
     * @param accessKeyName The workflow access key name.
     * @param resourceGroupName The resource group name.
     * @param workflowName The workflow name.
     * @return null
     */
    public suspend fun getWorkflowAccessKey(
        accessKeyName: String,
        resourceGroupName: String,
        workflowName: String,
    ): GetWorkflowAccessKeyResult {
        val argument = GetWorkflowAccessKeyPlainArgs(
            accessKeyName = accessKeyName,
            resourceGroupName = resourceGroupName,
            workflowName = workflowName,
        )
        return getWorkflowAccessKeyResultToKotlin(getWorkflowAccessKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkflowAccessKey].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;GetWorkflowAccessKeyPlainArgs].
     * @return null
     */
    public suspend fun getWorkflowAccessKey(argument: suspend GetWorkflowAccessKeyPlainArgsBuilder.() -> Unit): GetWorkflowAccessKeyResult {
        val builder = GetWorkflowAccessKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkflowAccessKeyResultToKotlin(getWorkflowAccessKeyPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the content callback url.
     * Azure REST API version: 2019-05-01.
     * @param argument null
     * @return The workflow trigger callback URL.
     */
    public suspend fun listIntegrationAccountAgreementContentCallbackUrl(argument: ListIntegrationAccountAgreementContentCallbackUrlPlainArgs): ListIntegrationAccountAgreementContentCallbackUrlResult =
        listIntegrationAccountAgreementContentCallbackUrlResultToKotlin(listIntegrationAccountAgreementContentCallbackUrlPlain(argument.toJava()).await())

    /**
     * @see [listIntegrationAccountAgreementContentCallbackUrl].
     * @param agreementName The integration account agreement name.
     * @param integrationAccountName The integration account name.
     * @param keyType The key type.
     * @param notAfter The expiry time.
     * @param resourceGroupName The resource group name.
     * @return The workflow trigger callback URL.
     */
    public suspend fun listIntegrationAccountAgreementContentCallbackUrl(
        agreementName: String,
        integrationAccountName: String,
        keyType: Either<String, KeyType>? = null,
        notAfter: String? = null,
        resourceGroupName: String,
    ): ListIntegrationAccountAgreementContentCallbackUrlResult {
        val argument = ListIntegrationAccountAgreementContentCallbackUrlPlainArgs(
            agreementName = agreementName,
            integrationAccountName = integrationAccountName,
            keyType = keyType,
            notAfter = notAfter,
            resourceGroupName = resourceGroupName,
        )
        return listIntegrationAccountAgreementContentCallbackUrlResultToKotlin(listIntegrationAccountAgreementContentCallbackUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [listIntegrationAccountAgreementContentCallbackUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;ListIntegrationAccountAgreementContentCallbackUrlPlainArgs].
     * @return The workflow trigger callback URL.
     */
    public suspend fun listIntegrationAccountAgreementContentCallbackUrl(argument: suspend ListIntegrationAccountAgreementContentCallbackUrlPlainArgsBuilder.() -> Unit): ListIntegrationAccountAgreementContentCallbackUrlResult {
        val builder = ListIntegrationAccountAgreementContentCallbackUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listIntegrationAccountAgreementContentCallbackUrlResultToKotlin(listIntegrationAccountAgreementContentCallbackUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the content callback url for an integration account assembly.
     * Azure REST API version: 2019-05-01.
     * @param argument null
     * @return The workflow trigger callback URL.
     */
    public suspend fun listIntegrationAccountAssemblyContentCallbackUrl(argument: ListIntegrationAccountAssemblyContentCallbackUrlPlainArgs): ListIntegrationAccountAssemblyContentCallbackUrlResult =
        listIntegrationAccountAssemblyContentCallbackUrlResultToKotlin(listIntegrationAccountAssemblyContentCallbackUrlPlain(argument.toJava()).await())

    /**
     * @see [listIntegrationAccountAssemblyContentCallbackUrl].
     * @param assemblyArtifactName The assembly artifact name.
     * @param integrationAccountName The integration account name.
     * @param resourceGroupName The resource group name.
     * @return The workflow trigger callback URL.
     */
    public suspend fun listIntegrationAccountAssemblyContentCallbackUrl(
        assemblyArtifactName: String,
        integrationAccountName: String,
        resourceGroupName: String,
    ): ListIntegrationAccountAssemblyContentCallbackUrlResult {
        val argument = ListIntegrationAccountAssemblyContentCallbackUrlPlainArgs(
            assemblyArtifactName = assemblyArtifactName,
            integrationAccountName = integrationAccountName,
            resourceGroupName = resourceGroupName,
        )
        return listIntegrationAccountAssemblyContentCallbackUrlResultToKotlin(listIntegrationAccountAssemblyContentCallbackUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [listIntegrationAccountAssemblyContentCallbackUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;ListIntegrationAccountAssemblyContentCallbackUrlPlainArgs].
     * @return The workflow trigger callback URL.
     */
    public suspend fun listIntegrationAccountAssemblyContentCallbackUrl(argument: suspend ListIntegrationAccountAssemblyContentCallbackUrlPlainArgsBuilder.() -> Unit): ListIntegrationAccountAssemblyContentCallbackUrlResult {
        val builder = ListIntegrationAccountAssemblyContentCallbackUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listIntegrationAccountAssemblyContentCallbackUrlResultToKotlin(listIntegrationAccountAssemblyContentCallbackUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the integration account callback URL.
     * Azure REST API version: 2019-05-01.
     * Other available API versions: 2015-08-01-preview.
     * @param argument null
     * @return The callback url.
     */
    public suspend fun listIntegrationAccountCallbackUrl(argument: ListIntegrationAccountCallbackUrlPlainArgs): ListIntegrationAccountCallbackUrlResult =
        listIntegrationAccountCallbackUrlResultToKotlin(listIntegrationAccountCallbackUrlPlain(argument.toJava()).await())

    /**
     * @see [listIntegrationAccountCallbackUrl].
     * @param integrationAccountName The integration account name.
     * @param keyType The key type.
     * @param notAfter The expiry time.
     * @param resourceGroupName The resource group name.
     * @return The callback url.
     */
    public suspend fun listIntegrationAccountCallbackUrl(
        integrationAccountName: String,
        keyType: Either<String, KeyType>? = null,
        notAfter: String? = null,
        resourceGroupName: String,
    ): ListIntegrationAccountCallbackUrlResult {
        val argument = ListIntegrationAccountCallbackUrlPlainArgs(
            integrationAccountName = integrationAccountName,
            keyType = keyType,
            notAfter = notAfter,
            resourceGroupName = resourceGroupName,
        )
        return listIntegrationAccountCallbackUrlResultToKotlin(listIntegrationAccountCallbackUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [listIntegrationAccountCallbackUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;ListIntegrationAccountCallbackUrlPlainArgs].
     * @return The callback url.
     */
    public suspend fun listIntegrationAccountCallbackUrl(argument: suspend ListIntegrationAccountCallbackUrlPlainArgsBuilder.() -> Unit): ListIntegrationAccountCallbackUrlResult {
        val builder = ListIntegrationAccountCallbackUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listIntegrationAccountCallbackUrlResultToKotlin(listIntegrationAccountCallbackUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the integration account's Key Vault keys.
     * Azure REST API version: 2019-05-01.
     * @param argument null
     * @return Collection of key vault keys.
     */
    public suspend fun listIntegrationAccountKeyVaultKeys(argument: ListIntegrationAccountKeyVaultKeysPlainArgs): ListIntegrationAccountKeyVaultKeysResult =
        listIntegrationAccountKeyVaultKeysResultToKotlin(listIntegrationAccountKeyVaultKeysPlain(argument.toJava()).await())

    /**
     * @see [listIntegrationAccountKeyVaultKeys].
     * @param integrationAccountName The integration account name.
     * @param keyVault The key vault reference.
     * @param resourceGroupName The resource group name.
     * @param skipToken The skip token.
     * @return Collection of key vault keys.
     */
    public suspend fun listIntegrationAccountKeyVaultKeys(
        integrationAccountName: String,
        keyVault: KeyVaultReference,
        resourceGroupName: String,
        skipToken: String? = null,
    ): ListIntegrationAccountKeyVaultKeysResult {
        val argument = ListIntegrationAccountKeyVaultKeysPlainArgs(
            integrationAccountName = integrationAccountName,
            keyVault = keyVault,
            resourceGroupName = resourceGroupName,
            skipToken = skipToken,
        )
        return listIntegrationAccountKeyVaultKeysResultToKotlin(listIntegrationAccountKeyVaultKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listIntegrationAccountKeyVaultKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;ListIntegrationAccountKeyVaultKeysPlainArgs].
     * @return Collection of key vault keys.
     */
    public suspend fun listIntegrationAccountKeyVaultKeys(argument: suspend ListIntegrationAccountKeyVaultKeysPlainArgsBuilder.() -> Unit): ListIntegrationAccountKeyVaultKeysResult {
        val builder = ListIntegrationAccountKeyVaultKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listIntegrationAccountKeyVaultKeysResultToKotlin(listIntegrationAccountKeyVaultKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the content callback url.
     * Azure REST API version: 2019-05-01.
     * @param argument null
     * @return The workflow trigger callback URL.
     */
    public suspend fun listIntegrationAccountMapContentCallbackUrl(argument: ListIntegrationAccountMapContentCallbackUrlPlainArgs): ListIntegrationAccountMapContentCallbackUrlResult =
        listIntegrationAccountMapContentCallbackUrlResultToKotlin(listIntegrationAccountMapContentCallbackUrlPlain(argument.toJava()).await())

    /**
     * @see [listIntegrationAccountMapContentCallbackUrl].
     * @param integrationAccountName The integration account name.
     * @param keyType The key type.
     * @param mapName The integration account map name.
     * @param notAfter The expiry time.
     * @param resourceGroupName The resource group name.
     * @return The workflow trigger callback URL.
     */
    public suspend fun listIntegrationAccountMapContentCallbackUrl(
        integrationAccountName: String,
        keyType: Either<String, KeyType>? = null,
        mapName: String,
        notAfter: String? = null,
        resourceGroupName: String,
    ): ListIntegrationAccountMapContentCallbackUrlResult {
        val argument = ListIntegrationAccountMapContentCallbackUrlPlainArgs(
            integrationAccountName = integrationAccountName,
            keyType = keyType,
            mapName = mapName,
            notAfter = notAfter,
            resourceGroupName = resourceGroupName,
        )
        return listIntegrationAccountMapContentCallbackUrlResultToKotlin(listIntegrationAccountMapContentCallbackUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [listIntegrationAccountMapContentCallbackUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;ListIntegrationAccountMapContentCallbackUrlPlainArgs].
     * @return The workflow trigger callback URL.
     */
    public suspend fun listIntegrationAccountMapContentCallbackUrl(argument: suspend ListIntegrationAccountMapContentCallbackUrlPlainArgsBuilder.() -> Unit): ListIntegrationAccountMapContentCallbackUrlResult {
        val builder = ListIntegrationAccountMapContentCallbackUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listIntegrationAccountMapContentCallbackUrlResultToKotlin(listIntegrationAccountMapContentCallbackUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the content callback url.
     * Azure REST API version: 2019-05-01.
     * @param argument null
     * @return The workflow trigger callback URL.
     */
    public suspend fun listIntegrationAccountPartnerContentCallbackUrl(argument: ListIntegrationAccountPartnerContentCallbackUrlPlainArgs): ListIntegrationAccountPartnerContentCallbackUrlResult =
        listIntegrationAccountPartnerContentCallbackUrlResultToKotlin(listIntegrationAccountPartnerContentCallbackUrlPlain(argument.toJava()).await())

    /**
     * @see [listIntegrationAccountPartnerContentCallbackUrl].
     * @param integrationAccountName The integration account name.
     * @param keyType The key type.
     * @param notAfter The expiry time.
     * @param partnerName The integration account partner name.
     * @param resourceGroupName The resource group name.
     * @return The workflow trigger callback URL.
     */
    public suspend fun listIntegrationAccountPartnerContentCallbackUrl(
        integrationAccountName: String,
        keyType: Either<String, KeyType>? = null,
        notAfter: String? = null,
        partnerName: String,
        resourceGroupName: String,
    ): ListIntegrationAccountPartnerContentCallbackUrlResult {
        val argument = ListIntegrationAccountPartnerContentCallbackUrlPlainArgs(
            integrationAccountName = integrationAccountName,
            keyType = keyType,
            notAfter = notAfter,
            partnerName = partnerName,
            resourceGroupName = resourceGroupName,
        )
        return listIntegrationAccountPartnerContentCallbackUrlResultToKotlin(listIntegrationAccountPartnerContentCallbackUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [listIntegrationAccountPartnerContentCallbackUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;ListIntegrationAccountPartnerContentCallbackUrlPlainArgs].
     * @return The workflow trigger callback URL.
     */
    public suspend fun listIntegrationAccountPartnerContentCallbackUrl(argument: suspend ListIntegrationAccountPartnerContentCallbackUrlPlainArgsBuilder.() -> Unit): ListIntegrationAccountPartnerContentCallbackUrlResult {
        val builder = ListIntegrationAccountPartnerContentCallbackUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listIntegrationAccountPartnerContentCallbackUrlResultToKotlin(listIntegrationAccountPartnerContentCallbackUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the content callback url.
     * Azure REST API version: 2019-05-01.
     * @param argument null
     * @return The workflow trigger callback URL.
     */
    public suspend fun listIntegrationAccountSchemaContentCallbackUrl(argument: ListIntegrationAccountSchemaContentCallbackUrlPlainArgs): ListIntegrationAccountSchemaContentCallbackUrlResult =
        listIntegrationAccountSchemaContentCallbackUrlResultToKotlin(listIntegrationAccountSchemaContentCallbackUrlPlain(argument.toJava()).await())

    /**
     * @see [listIntegrationAccountSchemaContentCallbackUrl].
     * @param integrationAccountName The integration account name.
     * @param keyType The key type.
     * @param notAfter The expiry time.
     * @param resourceGroupName The resource group name.
     * @param schemaName The integration account schema name.
     * @return The workflow trigger callback URL.
     */
    public suspend fun listIntegrationAccountSchemaContentCallbackUrl(
        integrationAccountName: String,
        keyType: Either<String, KeyType>? = null,
        notAfter: String? = null,
        resourceGroupName: String,
        schemaName: String,
    ): ListIntegrationAccountSchemaContentCallbackUrlResult {
        val argument = ListIntegrationAccountSchemaContentCallbackUrlPlainArgs(
            integrationAccountName = integrationAccountName,
            keyType = keyType,
            notAfter = notAfter,
            resourceGroupName = resourceGroupName,
            schemaName = schemaName,
        )
        return listIntegrationAccountSchemaContentCallbackUrlResultToKotlin(listIntegrationAccountSchemaContentCallbackUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [listIntegrationAccountSchemaContentCallbackUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;ListIntegrationAccountSchemaContentCallbackUrlPlainArgs].
     * @return The workflow trigger callback URL.
     */
    public suspend fun listIntegrationAccountSchemaContentCallbackUrl(argument: suspend ListIntegrationAccountSchemaContentCallbackUrlPlainArgsBuilder.() -> Unit): ListIntegrationAccountSchemaContentCallbackUrlResult {
        val builder = ListIntegrationAccountSchemaContentCallbackUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listIntegrationAccountSchemaContentCallbackUrlResultToKotlin(listIntegrationAccountSchemaContentCallbackUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists secret keys.
     * Azure REST API version: 2015-02-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun listWorkflowAccessKeySecretKeys(argument: ListWorkflowAccessKeySecretKeysPlainArgs): ListWorkflowAccessKeySecretKeysResult =
        listWorkflowAccessKeySecretKeysResultToKotlin(listWorkflowAccessKeySecretKeysPlain(argument.toJava()).await())

    /**
     * @see [listWorkflowAccessKeySecretKeys].
     * @param accessKeyName The workflow access key name.
     * @param resourceGroupName The resource group name.
     * @param workflowName The workflow name.
     * @return null
     */
    public suspend fun listWorkflowAccessKeySecretKeys(
        accessKeyName: String,
        resourceGroupName: String,
        workflowName: String,
    ): ListWorkflowAccessKeySecretKeysResult {
        val argument = ListWorkflowAccessKeySecretKeysPlainArgs(
            accessKeyName = accessKeyName,
            resourceGroupName = resourceGroupName,
            workflowName = workflowName,
        )
        return listWorkflowAccessKeySecretKeysResultToKotlin(listWorkflowAccessKeySecretKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listWorkflowAccessKeySecretKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;ListWorkflowAccessKeySecretKeysPlainArgs].
     * @return null
     */
    public suspend fun listWorkflowAccessKeySecretKeys(argument: suspend ListWorkflowAccessKeySecretKeysPlainArgsBuilder.() -> Unit): ListWorkflowAccessKeySecretKeysResult {
        val builder = ListWorkflowAccessKeySecretKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWorkflowAccessKeySecretKeysResultToKotlin(listWorkflowAccessKeySecretKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the workflow callback Url.
     * Azure REST API version: 2019-05-01.
     * Other available API versions: 2016-06-01, 2018-07-01-preview.
     * @param argument null
     * @return The workflow trigger callback URL.
     */
    public suspend fun listWorkflowCallbackUrl(argument: ListWorkflowCallbackUrlPlainArgs): ListWorkflowCallbackUrlResult =
        listWorkflowCallbackUrlResultToKotlin(listWorkflowCallbackUrlPlain(argument.toJava()).await())

    /**
     * @see [listWorkflowCallbackUrl].
     * @param keyType The key type.
     * @param notAfter The expiry time.
     * @param resourceGroupName The resource group name.
     * @param workflowName The workflow name.
     * @return The workflow trigger callback URL.
     */
    public suspend fun listWorkflowCallbackUrl(
        keyType: Either<String, KeyType>? = null,
        notAfter: String? = null,
        resourceGroupName: String,
        workflowName: String,
    ): ListWorkflowCallbackUrlResult {
        val argument = ListWorkflowCallbackUrlPlainArgs(
            keyType = keyType,
            notAfter = notAfter,
            resourceGroupName = resourceGroupName,
            workflowName = workflowName,
        )
        return listWorkflowCallbackUrlResultToKotlin(listWorkflowCallbackUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [listWorkflowCallbackUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;ListWorkflowCallbackUrlPlainArgs].
     * @return The workflow trigger callback URL.
     */
    public suspend fun listWorkflowCallbackUrl(argument: suspend ListWorkflowCallbackUrlPlainArgsBuilder.() -> Unit): ListWorkflowCallbackUrlResult {
        val builder = ListWorkflowCallbackUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWorkflowCallbackUrlResultToKotlin(listWorkflowCallbackUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists a workflow run expression trace.
     * Azure REST API version: 2019-05-01.
     * Other available API versions: 2016-06-01, 2018-07-01-preview.
     * @param argument null
     * @return The expression traces.
     */
    public suspend fun listWorkflowRunActionExpressionTraces(argument: ListWorkflowRunActionExpressionTracesPlainArgs): ListWorkflowRunActionExpressionTracesResult =
        listWorkflowRunActionExpressionTracesResultToKotlin(listWorkflowRunActionExpressionTracesPlain(argument.toJava()).await())

    /**
     * @see [listWorkflowRunActionExpressionTraces].
     * @param actionName The workflow action name.
     * @param resourceGroupName The resource group name.
     * @param runName The workflow run name.
     * @param workflowName The workflow name.
     * @return The expression traces.
     */
    public suspend fun listWorkflowRunActionExpressionTraces(
        actionName: String,
        resourceGroupName: String,
        runName: String,
        workflowName: String,
    ): ListWorkflowRunActionExpressionTracesResult {
        val argument = ListWorkflowRunActionExpressionTracesPlainArgs(
            actionName = actionName,
            resourceGroupName = resourceGroupName,
            runName = runName,
            workflowName = workflowName,
        )
        return listWorkflowRunActionExpressionTracesResultToKotlin(listWorkflowRunActionExpressionTracesPlain(argument.toJava()).await())
    }

    /**
     * @see [listWorkflowRunActionExpressionTraces].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;ListWorkflowRunActionExpressionTracesPlainArgs].
     * @return The expression traces.
     */
    public suspend fun listWorkflowRunActionExpressionTraces(argument: suspend ListWorkflowRunActionExpressionTracesPlainArgsBuilder.() -> Unit): ListWorkflowRunActionExpressionTracesResult {
        val builder = ListWorkflowRunActionExpressionTracesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWorkflowRunActionExpressionTracesResultToKotlin(listWorkflowRunActionExpressionTracesPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists a workflow run expression trace.
     * Azure REST API version: 2019-05-01.
     * Other available API versions: 2016-06-01, 2018-07-01-preview.
     * @param argument null
     * @return The expression traces.
     */
    public suspend fun listWorkflowRunActionRepetitionExpressionTraces(argument: ListWorkflowRunActionRepetitionExpressionTracesPlainArgs): ListWorkflowRunActionRepetitionExpressionTracesResult =
        listWorkflowRunActionRepetitionExpressionTracesResultToKotlin(listWorkflowRunActionRepetitionExpressionTracesPlain(argument.toJava()).await())

    /**
     * @see [listWorkflowRunActionRepetitionExpressionTraces].
     * @param actionName The workflow action name.
     * @param repetitionName The workflow repetition.
     * @param resourceGroupName The resource group name.
     * @param runName The workflow run name.
     * @param workflowName The workflow name.
     * @return The expression traces.
     */
    public suspend fun listWorkflowRunActionRepetitionExpressionTraces(
        actionName: String,
        repetitionName: String,
        resourceGroupName: String,
        runName: String,
        workflowName: String,
    ): ListWorkflowRunActionRepetitionExpressionTracesResult {
        val argument = ListWorkflowRunActionRepetitionExpressionTracesPlainArgs(
            actionName = actionName,
            repetitionName = repetitionName,
            resourceGroupName = resourceGroupName,
            runName = runName,
            workflowName = workflowName,
        )
        return listWorkflowRunActionRepetitionExpressionTracesResultToKotlin(listWorkflowRunActionRepetitionExpressionTracesPlain(argument.toJava()).await())
    }

    /**
     * @see [listWorkflowRunActionRepetitionExpressionTraces].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;ListWorkflowRunActionRepetitionExpressionTracesPlainArgs].
     * @return The expression traces.
     */
    public suspend fun listWorkflowRunActionRepetitionExpressionTraces(argument: suspend ListWorkflowRunActionRepetitionExpressionTracesPlainArgsBuilder.() -> Unit): ListWorkflowRunActionRepetitionExpressionTracesResult {
        val builder = ListWorkflowRunActionRepetitionExpressionTracesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWorkflowRunActionRepetitionExpressionTracesResultToKotlin(listWorkflowRunActionRepetitionExpressionTracesPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the callback URL for a workflow trigger.
     * Azure REST API version: 2019-05-01.
     * Other available API versions: 2016-06-01, 2018-07-01-preview.
     * @param argument null
     * @return The workflow trigger callback URL.
     */
    public suspend fun listWorkflowTriggerCallbackUrl(argument: ListWorkflowTriggerCallbackUrlPlainArgs): ListWorkflowTriggerCallbackUrlResult =
        listWorkflowTriggerCallbackUrlResultToKotlin(listWorkflowTriggerCallbackUrlPlain(argument.toJava()).await())

    /**
     * @see [listWorkflowTriggerCallbackUrl].
     * @param resourceGroupName The resource group name.
     * @param triggerName The workflow trigger name.
     * @param workflowName The workflow name.
     * @return The workflow trigger callback URL.
     */
    public suspend fun listWorkflowTriggerCallbackUrl(
        resourceGroupName: String,
        triggerName: String,
        workflowName: String,
    ): ListWorkflowTriggerCallbackUrlResult {
        val argument = ListWorkflowTriggerCallbackUrlPlainArgs(
            resourceGroupName = resourceGroupName,
            triggerName = triggerName,
            workflowName = workflowName,
        )
        return listWorkflowTriggerCallbackUrlResultToKotlin(listWorkflowTriggerCallbackUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [listWorkflowTriggerCallbackUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;ListWorkflowTriggerCallbackUrlPlainArgs].
     * @return The workflow trigger callback URL.
     */
    public suspend fun listWorkflowTriggerCallbackUrl(argument: suspend ListWorkflowTriggerCallbackUrlPlainArgsBuilder.() -> Unit): ListWorkflowTriggerCallbackUrlResult {
        val builder = ListWorkflowTriggerCallbackUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWorkflowTriggerCallbackUrlResultToKotlin(listWorkflowTriggerCallbackUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the callback url for a trigger of a workflow version.
     * Azure REST API version: 2016-06-01.
     * @param argument null
     * @return The workflow trigger callback URL.
     */
    public suspend fun listWorkflowVersionCallbackUrl(argument: ListWorkflowVersionCallbackUrlPlainArgs): ListWorkflowVersionCallbackUrlResult =
        listWorkflowVersionCallbackUrlResultToKotlin(listWorkflowVersionCallbackUrlPlain(argument.toJava()).await())

    /**
     * @see [listWorkflowVersionCallbackUrl].
     * @param keyType The key type.
     * @param notAfter The expiry time.
     * @param resourceGroupName The resource group name.
     * @param triggerName The workflow trigger name.
     * @param versionId The workflow versionId.
     * @param workflowName The workflow name.
     * @return The workflow trigger callback URL.
     */
    public suspend fun listWorkflowVersionCallbackUrl(
        keyType: KeyType? = null,
        notAfter: String? = null,
        resourceGroupName: String,
        triggerName: String,
        versionId: String,
        workflowName: String,
    ): ListWorkflowVersionCallbackUrlResult {
        val argument = ListWorkflowVersionCallbackUrlPlainArgs(
            keyType = keyType,
            notAfter = notAfter,
            resourceGroupName = resourceGroupName,
            triggerName = triggerName,
            versionId = versionId,
            workflowName = workflowName,
        )
        return listWorkflowVersionCallbackUrlResultToKotlin(listWorkflowVersionCallbackUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [listWorkflowVersionCallbackUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;ListWorkflowVersionCallbackUrlPlainArgs].
     * @return The workflow trigger callback URL.
     */
    public suspend fun listWorkflowVersionCallbackUrl(argument: suspend ListWorkflowVersionCallbackUrlPlainArgsBuilder.() -> Unit): ListWorkflowVersionCallbackUrlResult {
        val builder = ListWorkflowVersionCallbackUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWorkflowVersionCallbackUrlResultToKotlin(listWorkflowVersionCallbackUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the callback url for a trigger of a workflow version.
     * Azure REST API version: 2019-05-01.
     * Other available API versions: 2018-07-01-preview.
     * @param argument null
     * @return The workflow trigger callback URL.
     */
    public suspend fun listWorkflowVersionTriggerCallbackUrl(argument: ListWorkflowVersionTriggerCallbackUrlPlainArgs): ListWorkflowVersionTriggerCallbackUrlResult =
        listWorkflowVersionTriggerCallbackUrlResultToKotlin(listWorkflowVersionTriggerCallbackUrlPlain(argument.toJava()).await())

    /**
     * @see [listWorkflowVersionTriggerCallbackUrl].
     * @param keyType The key type.
     * @param notAfter The expiry time.
     * @param resourceGroupName The resource group name.
     * @param triggerName The workflow trigger name.
     * @param versionId The workflow versionId.
     * @param workflowName The workflow name.
     * @return The workflow trigger callback URL.
     */
    public suspend fun listWorkflowVersionTriggerCallbackUrl(
        keyType: Either<String, KeyType>? = null,
        notAfter: String? = null,
        resourceGroupName: String,
        triggerName: String,
        versionId: String,
        workflowName: String,
    ): ListWorkflowVersionTriggerCallbackUrlResult {
        val argument = ListWorkflowVersionTriggerCallbackUrlPlainArgs(
            keyType = keyType,
            notAfter = notAfter,
            resourceGroupName = resourceGroupName,
            triggerName = triggerName,
            versionId = versionId,
            workflowName = workflowName,
        )
        return listWorkflowVersionTriggerCallbackUrlResultToKotlin(listWorkflowVersionTriggerCallbackUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [listWorkflowVersionTriggerCallbackUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logic&#46;kotlin&#46;inputs&#46;ListWorkflowVersionTriggerCallbackUrlPlainArgs].
     * @return The workflow trigger callback URL.
     */
    public suspend fun listWorkflowVersionTriggerCallbackUrl(argument: suspend ListWorkflowVersionTriggerCallbackUrlPlainArgsBuilder.() -> Unit): ListWorkflowVersionTriggerCallbackUrlResult {
        val builder = ListWorkflowVersionTriggerCallbackUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWorkflowVersionTriggerCallbackUrlResultToKotlin(listWorkflowVersionTriggerCallbackUrlPlain(builtArgument.toJava()).await())
    }
}
