@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.kotlin.outputs.RosettaNetPipActivitySettingsResponse
import com.pulumi.azurenative.logic.kotlin.outputs.RosettaNetPipRoleSettingsResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.logic.kotlin.outputs.RosettaNetPipActivitySettingsResponse.Companion.toKotlin as rosettaNetPipActivitySettingsResponseToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.RosettaNetPipRoleSettingsResponse.Companion.toKotlin as rosettaNetPipRoleSettingsResponseToKotlin

/**
 * Builder for [RosettaNetProcessConfiguration].
 */
@PulumiTagMarker
public class RosettaNetProcessConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RosettaNetProcessConfigurationArgs = RosettaNetProcessConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RosettaNetProcessConfigurationArgsBuilder.() -> Unit) {
        val builder = RosettaNetProcessConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RosettaNetProcessConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.logic.RosettaNetProcessConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RosettaNetProcessConfiguration(builtJavaResource)
    }
}

/**
 * The integration account RosettaNet process configuration.
 * Azure REST API version: 2016-06-01. Prior API version in Azure Native 1.x: 2016-06-01.
 * ## Example Usage
 * ### Create or update an RosettaNetProcessConfiguration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var rosettaNetProcessConfiguration = new AzureNative.Logic.RosettaNetProcessConfiguration("rosettaNetProcessConfiguration", new()
 *     {
 *         ActivitySettings = new AzureNative.Logic.Inputs.RosettaNetPipActivitySettingsArgs
 *         {
 *             AcknowledgmentOfReceiptSettings = new AzureNative.Logic.Inputs.RosettaNetPipAcknowledgmentOfReceiptSettingsArgs
 *             {
 *                 IsNonRepudiationRequired = false,
 *                 TimeToAcknowledgeInSeconds = 600,
 *             },
 *             ActivityBehavior = new AzureNative.Logic.Inputs.RosettaNetPipActivityBehaviorArgs
 *             {
 *                 ActionType = AzureNative.Logic.RosettaNetActionType.DoubleAction,
 *                 IsAuthorizationRequired = false,
 *                 IsSecuredTransportRequired = false,
 *                 NonRepudiationOfOriginAndContent = false,
 *                 PersistentConfidentialityScope = AzureNative.Logic.RosettaNetPipConfidentialityScope.None,
 *                 ResponseType = AzureNative.Logic.RosettaNetResponseType.Async,
 *                 RetryCount = 2,
 *                 TimeToPerformInSeconds = 7200,
 *             },
 *             ActivityType = AzureNative.Logic.RosettaNetPipActivityType.RequestResponse,
 *         },
 *         Description = "Test description",
 *         InitiatorRoleSettings = new AzureNative.Logic.Inputs.RosettaNetPipRoleSettingsArgs
 *         {
 *             Action = "Purchase Order Request",
 *             BusinessDocument = new AzureNative.Logic.Inputs.RosettaNetPipBusinessDocumentArgs
 *             {
 *                 Description = "A request to accept a purchase order for fulfillment..",
 *                 Name = "Purchase Order Request",
 *                 Version = "V02.02.00",
 *             },
 *             Description = "This partner role creates a demand for a product or service.",
 *             Role = "Buyer",
 *             RoleType = AzureNative.Logic.RosettaNetPipRoleType.Functional,
 *             Service = "Buyer Service",
 *             ServiceClassification = "Business Service",
 *         },
 *         IntegrationAccountName = "testia123",
 *         ProcessCode = "3A4",
 *         ProcessName = "Request Purchase Order",
 *         ProcessVersion = "V02.02.00",
 *         ResourceGroupName = "testrg123",
 *         ResponderRoleSettings = new AzureNative.Logic.Inputs.RosettaNetPipRoleSettingsArgs
 *         {
 *             Action = "Purchase Order Confirmation Action",
 *             BusinessDocument = new AzureNative.Logic.Inputs.RosettaNetPipBusinessDocumentArgs
 *             {
 *                 Description = "Formally confirms the status of line item(s) in a Purchase Order. A Purchase Order line item may have one of the following states: accepted, rejected, or pending.",
 *                 Name = "Purchase Order Confirmation",
 *                 Version = "V02.02.00",
 *             },
 *             Description = "An organization that sells products to partners in the supply chain.",
 *             Role = "Seller",
 *             RoleType = AzureNative.Logic.RosettaNetPipRoleType.Organizational,
 *             Service = "Seller Service",
 *             ServiceClassification = "Business Service",
 *         },
 *         RosettaNetProcessConfigurationName = "3A4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewRosettaNetProcessConfiguration(ctx, "rosettaNetProcessConfiguration", &logic.RosettaNetProcessConfigurationArgs{
 * 			ActivitySettings: &logic.RosettaNetPipActivitySettingsArgs{
 * 				AcknowledgmentOfReceiptSettings: &logic.RosettaNetPipAcknowledgmentOfReceiptSettingsArgs{
 * 					IsNonRepudiationRequired:   pulumi.Bool(false),
 * 					TimeToAcknowledgeInSeconds: pulumi.Int(600),
 * 				},
 * 				ActivityBehavior: &logic.RosettaNetPipActivityBehaviorArgs{
 * 					ActionType:                       logic.RosettaNetActionTypeDoubleAction,
 * 					IsAuthorizationRequired:          pulumi.Bool(false),
 * 					IsSecuredTransportRequired:       pulumi.Bool(false),
 * 					NonRepudiationOfOriginAndContent: pulumi.Bool(false),
 * 					PersistentConfidentialityScope:   logic.RosettaNetPipConfidentialityScopeNone,
 * 					ResponseType:                     logic.RosettaNetResponseTypeAsync,
 * 					RetryCount:                       pulumi.Int(2),
 * 					TimeToPerformInSeconds:           pulumi.Int(7200),
 * 				},
 * 				ActivityType: logic.RosettaNetPipActivityTypeRequestResponse,
 * 			},
 * 			Description: pulumi.String("Test description"),
 * 			InitiatorRoleSettings: &logic.RosettaNetPipRoleSettingsArgs{
 * 				Action: pulumi.String("Purchase Order Request"),
 * 				BusinessDocument: &logic.RosettaNetPipBusinessDocumentArgs{
 * 					Description: pulumi.String("A request to accept a purchase order for fulfillment.."),
 * 					Name:        pulumi.String("Purchase Order Request"),
 * 					Version:     pulumi.String("V02.02.00"),
 * 				},
 * 				Description:           pulumi.String("This partner role creates a demand for a product or service."),
 * 				Role:                  pulumi.String("Buyer"),
 * 				RoleType:              logic.RosettaNetPipRoleTypeFunctional,
 * 				Service:               pulumi.String("Buyer Service"),
 * 				ServiceClassification: pulumi.String("Business Service"),
 * 			},
 * 			IntegrationAccountName: pulumi.String("testia123"),
 * 			ProcessCode:            pulumi.String("3A4"),
 * 			ProcessName:            pulumi.String("Request Purchase Order"),
 * 			ProcessVersion:         pulumi.String("V02.02.00"),
 * 			ResourceGroupName:      pulumi.String("testrg123"),
 * 			ResponderRoleSettings: &logic.RosettaNetPipRoleSettingsArgs{
 * 				Action: pulumi.String("Purchase Order Confirmation Action"),
 * 				BusinessDocument: &logic.RosettaNetPipBusinessDocumentArgs{
 * 					Description: pulumi.String("Formally confirms the status of line item(s) in a Purchase Order. A Purchase Order line item may have one of the following states: accepted, rejected, or pending."),
 * 					Name:        pulumi.String("Purchase Order Confirmation"),
 * 					Version:     pulumi.String("V02.02.00"),
 * 				},
 * 				Description:           pulumi.String("An organization that sells products to partners in the supply chain."),
 * 				Role:                  pulumi.String("Seller"),
 * 				RoleType:              logic.RosettaNetPipRoleTypeOrganizational,
 * 				Service:               pulumi.String("Seller Service"),
 * 				ServiceClassification: pulumi.String("Business Service"),
 * 			},
 * 			RosettaNetProcessConfigurationName: pulumi.String("3A4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.RosettaNetProcessConfiguration;
 * import com.pulumi.azurenative.logic.RosettaNetProcessConfigurationArgs;
 * import com.pulumi.azurenative.logic.inputs.RosettaNetPipActivitySettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.RosettaNetPipAcknowledgmentOfReceiptSettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.RosettaNetPipActivityBehaviorArgs;
 * import com.pulumi.azurenative.logic.inputs.RosettaNetPipRoleSettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.RosettaNetPipBusinessDocumentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var rosettaNetProcessConfiguration = new RosettaNetProcessConfiguration("rosettaNetProcessConfiguration", RosettaNetProcessConfigurationArgs.builder()
 *             .activitySettings(RosettaNetPipActivitySettingsArgs.builder()
 *                 .acknowledgmentOfReceiptSettings(RosettaNetPipAcknowledgmentOfReceiptSettingsArgs.builder()
 *                     .isNonRepudiationRequired(false)
 *                     .timeToAcknowledgeInSeconds(600)
 *                     .build())
 *                 .activityBehavior(RosettaNetPipActivityBehaviorArgs.builder()
 *                     .actionType("DoubleAction")
 *                     .isAuthorizationRequired(false)
 *                     .isSecuredTransportRequired(false)
 *                     .nonRepudiationOfOriginAndContent(false)
 *                     .persistentConfidentialityScope("None")
 *                     .responseType("Async")
 *                     .retryCount(2)
 *                     .timeToPerformInSeconds(7200)
 *                     .build())
 *                 .activityType("RequestResponse")
 *                 .build())
 *             .description("Test description")
 *             .initiatorRoleSettings(RosettaNetPipRoleSettingsArgs.builder()
 *                 .action("Purchase Order Request")
 *                 .businessDocument(RosettaNetPipBusinessDocumentArgs.builder()
 *                     .description("A request to accept a purchase order for fulfillment..")
 *                     .name("Purchase Order Request")
 *                     .version("V02.02.00")
 *                     .build())
 *                 .description("This partner role creates a demand for a product or service.")
 *                 .role("Buyer")
 *                 .roleType("Functional")
 *                 .service("Buyer Service")
 *                 .serviceClassification("Business Service")
 *                 .build())
 *             .integrationAccountName("testia123")
 *             .processCode("3A4")
 *             .processName("Request Purchase Order")
 *             .processVersion("V02.02.00")
 *             .resourceGroupName("testrg123")
 *             .responderRoleSettings(RosettaNetPipRoleSettingsArgs.builder()
 *                 .action("Purchase Order Confirmation Action")
 *                 .businessDocument(RosettaNetPipBusinessDocumentArgs.builder()
 *                     .description("Formally confirms the status of line item(s) in a Purchase Order. A Purchase Order line item may have one of the following states: accepted, rejected, or pending.")
 *                     .name("Purchase Order Confirmation")
 *                     .version("V02.02.00")
 *                     .build())
 *                 .description("An organization that sells products to partners in the supply chain.")
 *                 .role("Seller")
 *                 .roleType("Organizational")
 *                 .service("Seller Service")
 *                 .serviceClassification("Business Service")
 *                 .build())
 *             .rosettaNetProcessConfigurationName("3A4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:RosettaNetProcessConfiguration 3A4 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/rosettanetprocessconfigurations/{rosettaNetProcessConfigurationName}
 * ```
 */
public class RosettaNetProcessConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.logic.RosettaNetProcessConfiguration,
) : KotlinCustomResource(javaResource, RosettaNetProcessConfigurationMapper) {
    /**
     * The RosettaNet process configuration activity settings.
     */
    public val activitySettings: Output<RosettaNetPipActivitySettingsResponse>
        get() = javaResource.activitySettings().applyValue({ args0 ->
            args0.let({ args0 ->
                rosettaNetPipActivitySettingsResponseToKotlin(args0)
            })
        })

    /**
     * The changed time.
     */
    public val changedTime: Output<String>
        get() = javaResource.changedTime().applyValue({ args0 -> args0 })

    /**
     * The created time.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * The integration account RosettaNet ProcessConfiguration properties.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The RosettaNet initiator role settings.
     */
    public val initiatorRoleSettings: Output<RosettaNetPipRoleSettingsResponse>
        get() = javaResource.initiatorRoleSettings().applyValue({ args0 ->
            args0.let({ args0 ->
                rosettaNetPipRoleSettingsResponseToKotlin(args0)
            })
        })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The metadata.
     */
    public val metadata: Output<Map<String, String>>?
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets the resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The integration account RosettaNet process code.
     */
    public val processCode: Output<String>
        get() = javaResource.processCode().applyValue({ args0 -> args0 })

    /**
     * The integration account RosettaNet process name.
     */
    public val processName: Output<String>
        get() = javaResource.processName().applyValue({ args0 -> args0 })

    /**
     * The integration account RosettaNet process version.
     */
    public val processVersion: Output<String>
        get() = javaResource.processVersion().applyValue({ args0 -> args0 })

    /**
     * The RosettaNet responder role settings.
     */
    public val responderRoleSettings: Output<RosettaNetPipRoleSettingsResponse>
        get() = javaResource.responderRoleSettings().applyValue({ args0 ->
            args0.let({ args0 ->
                rosettaNetPipRoleSettingsResponseToKotlin(args0)
            })
        })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets the resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RosettaNetProcessConfigurationMapper : ResourceMapper<RosettaNetProcessConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.logic.RosettaNetProcessConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): RosettaNetProcessConfiguration =
        RosettaNetProcessConfiguration(
            javaResource as
                com.pulumi.azurenative.logic.RosettaNetProcessConfiguration,
        )
}

/**
 * @see [RosettaNetProcessConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RosettaNetProcessConfiguration].
 */
public suspend fun rosettaNetProcessConfiguration(
    name: String,
    block: suspend RosettaNetProcessConfigurationResourceBuilder.() -> Unit,
): RosettaNetProcessConfiguration {
    val builder = RosettaNetProcessConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RosettaNetProcessConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rosettaNetProcessConfiguration(name: String): RosettaNetProcessConfiguration {
    val builder = RosettaNetProcessConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
