@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.AS2ValidationSettingsArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.EncryptionAlgorithm
import com.pulumi.azurenative.logic.kotlin.enums.SigningAlgorithm
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The AS2 agreement validation settings.
 * @property checkCertificateRevocationListOnReceive The value indicating whether to check for certificate revocation list on receive.
 * @property checkCertificateRevocationListOnSend The value indicating whether to check for certificate revocation list on send.
 * @property checkDuplicateMessage The value indicating whether to check for duplicate message.
 * @property compressMessage The value indicating whether the message has to be compressed.
 * @property encryptMessage The value indicating whether the message has to be encrypted.
 * @property encryptionAlgorithm The encryption algorithm.
 * @property interchangeDuplicatesValidityDays The number of days to look back for duplicate interchange.
 * @property overrideMessageProperties The value indicating whether to override incoming message properties with those in agreement.
 * @property signMessage The value indicating whether the message has to be signed.
 * @property signingAlgorithm The signing algorithm.
 */
public data class AS2ValidationSettingsArgs(
    public val checkCertificateRevocationListOnReceive: Output<Boolean>,
    public val checkCertificateRevocationListOnSend: Output<Boolean>,
    public val checkDuplicateMessage: Output<Boolean>,
    public val compressMessage: Output<Boolean>,
    public val encryptMessage: Output<Boolean>,
    public val encryptionAlgorithm: Output<Either<String, EncryptionAlgorithm>>,
    public val interchangeDuplicatesValidityDays: Output<Int>,
    public val overrideMessageProperties: Output<Boolean>,
    public val signMessage: Output<Boolean>,
    public val signingAlgorithm: Output<Either<String, SigningAlgorithm>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.AS2ValidationSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.AS2ValidationSettingsArgs =
        com.pulumi.azurenative.logic.inputs.AS2ValidationSettingsArgs.builder()
            .checkCertificateRevocationListOnReceive(
                checkCertificateRevocationListOnReceive.applyValue({ args0 ->
                    args0
                }),
            )
            .checkCertificateRevocationListOnSend(
                checkCertificateRevocationListOnSend.applyValue({ args0 ->
                    args0
                }),
            )
            .checkDuplicateMessage(checkDuplicateMessage.applyValue({ args0 -> args0 }))
            .compressMessage(compressMessage.applyValue({ args0 -> args0 }))
            .encryptMessage(encryptMessage.applyValue({ args0 -> args0 }))
            .encryptionAlgorithm(
                encryptionAlgorithm.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .interchangeDuplicatesValidityDays(interchangeDuplicatesValidityDays.applyValue({ args0 -> args0 }))
            .overrideMessageProperties(overrideMessageProperties.applyValue({ args0 -> args0 }))
            .signMessage(signMessage.applyValue({ args0 -> args0 }))
            .signingAlgorithm(
                signingAlgorithm?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [AS2ValidationSettingsArgs].
 */
@PulumiTagMarker
public class AS2ValidationSettingsArgsBuilder internal constructor() {
    private var checkCertificateRevocationListOnReceive: Output<Boolean>? = null

    private var checkCertificateRevocationListOnSend: Output<Boolean>? = null

    private var checkDuplicateMessage: Output<Boolean>? = null

    private var compressMessage: Output<Boolean>? = null

    private var encryptMessage: Output<Boolean>? = null

    private var encryptionAlgorithm: Output<Either<String, EncryptionAlgorithm>>? = null

    private var interchangeDuplicatesValidityDays: Output<Int>? = null

    private var overrideMessageProperties: Output<Boolean>? = null

    private var signMessage: Output<Boolean>? = null

    private var signingAlgorithm: Output<Either<String, SigningAlgorithm>>? = null

    /**
     * @param value The value indicating whether to check for certificate revocation list on receive.
     */
    @JvmName("nugvoajdqwbwjnms")
    public suspend fun checkCertificateRevocationListOnReceive(`value`: Output<Boolean>) {
        this.checkCertificateRevocationListOnReceive = value
    }

    /**
     * @param value The value indicating whether to check for certificate revocation list on send.
     */
    @JvmName("vvdfthrmpvunepnt")
    public suspend fun checkCertificateRevocationListOnSend(`value`: Output<Boolean>) {
        this.checkCertificateRevocationListOnSend = value
    }

    /**
     * @param value The value indicating whether to check for duplicate message.
     */
    @JvmName("yixukpxwhpexngny")
    public suspend fun checkDuplicateMessage(`value`: Output<Boolean>) {
        this.checkDuplicateMessage = value
    }

    /**
     * @param value The value indicating whether the message has to be compressed.
     */
    @JvmName("keyaftlrgpeaqnqt")
    public suspend fun compressMessage(`value`: Output<Boolean>) {
        this.compressMessage = value
    }

    /**
     * @param value The value indicating whether the message has to be encrypted.
     */
    @JvmName("dygrtksjhjnwgbtp")
    public suspend fun encryptMessage(`value`: Output<Boolean>) {
        this.encryptMessage = value
    }

    /**
     * @param value The encryption algorithm.
     */
    @JvmName("ocuugmapxviadfiw")
    public suspend fun encryptionAlgorithm(`value`: Output<Either<String, EncryptionAlgorithm>>) {
        this.encryptionAlgorithm = value
    }

    /**
     * @param value The number of days to look back for duplicate interchange.
     */
    @JvmName("nybafnckecalwwrg")
    public suspend fun interchangeDuplicatesValidityDays(`value`: Output<Int>) {
        this.interchangeDuplicatesValidityDays = value
    }

    /**
     * @param value The value indicating whether to override incoming message properties with those in agreement.
     */
    @JvmName("pithnltybvquheis")
    public suspend fun overrideMessageProperties(`value`: Output<Boolean>) {
        this.overrideMessageProperties = value
    }

    /**
     * @param value The value indicating whether the message has to be signed.
     */
    @JvmName("jtyqyphewwyvront")
    public suspend fun signMessage(`value`: Output<Boolean>) {
        this.signMessage = value
    }

    /**
     * @param value The signing algorithm.
     */
    @JvmName("oyawkkrhmltokodi")
    public suspend fun signingAlgorithm(`value`: Output<Either<String, SigningAlgorithm>>) {
        this.signingAlgorithm = value
    }

    /**
     * @param value The value indicating whether to check for certificate revocation list on receive.
     */
    @JvmName("uugtnvjsflqtouhf")
    public suspend fun checkCertificateRevocationListOnReceive(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.checkCertificateRevocationListOnReceive = mapped
    }

    /**
     * @param value The value indicating whether to check for certificate revocation list on send.
     */
    @JvmName("aomimbrvyjtnbesm")
    public suspend fun checkCertificateRevocationListOnSend(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.checkCertificateRevocationListOnSend = mapped
    }

    /**
     * @param value The value indicating whether to check for duplicate message.
     */
    @JvmName("akueianxyvvcbyob")
    public suspend fun checkDuplicateMessage(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.checkDuplicateMessage = mapped
    }

    /**
     * @param value The value indicating whether the message has to be compressed.
     */
    @JvmName("tlfpbaudjbybghwg")
    public suspend fun compressMessage(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.compressMessage = mapped
    }

    /**
     * @param value The value indicating whether the message has to be encrypted.
     */
    @JvmName("owklwyrfmsjpwiue")
    public suspend fun encryptMessage(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptMessage = mapped
    }

    /**
     * @param value The encryption algorithm.
     */
    @JvmName("gixxjeoddbuibwfu")
    public suspend fun encryptionAlgorithm(`value`: Either<String, EncryptionAlgorithm>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionAlgorithm = mapped
    }

    /**
     * @param value The encryption algorithm.
     */
    @JvmName("nxlmbapkqwlbtpdt")
    public fun encryptionAlgorithm(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncryptionAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionAlgorithm = mapped
    }

    /**
     * @param value The encryption algorithm.
     */
    @JvmName("vhmbnpliqskwgudy")
    public fun encryptionAlgorithm(`value`: EncryptionAlgorithm) {
        val toBeMapped = Either.ofRight<String, EncryptionAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionAlgorithm = mapped
    }

    /**
     * @param value The number of days to look back for duplicate interchange.
     */
    @JvmName("fwnslsbmqnyiyryu")
    public suspend fun interchangeDuplicatesValidityDays(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.interchangeDuplicatesValidityDays = mapped
    }

    /**
     * @param value The value indicating whether to override incoming message properties with those in agreement.
     */
    @JvmName("wekeurtnayybehey")
    public suspend fun overrideMessageProperties(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.overrideMessageProperties = mapped
    }

    /**
     * @param value The value indicating whether the message has to be signed.
     */
    @JvmName("lnfrntumxcmalndn")
    public suspend fun signMessage(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.signMessage = mapped
    }

    /**
     * @param value The signing algorithm.
     */
    @JvmName("lbbfjikktgwmwpux")
    public suspend fun signingAlgorithm(`value`: Either<String, SigningAlgorithm>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signingAlgorithm = mapped
    }

    /**
     * @param value The signing algorithm.
     */
    @JvmName("kslgvrnpwofmsljy")
    public fun signingAlgorithm(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SigningAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.signingAlgorithm = mapped
    }

    /**
     * @param value The signing algorithm.
     */
    @JvmName("rubthgcnbqidpucq")
    public fun signingAlgorithm(`value`: SigningAlgorithm) {
        val toBeMapped = Either.ofRight<String, SigningAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.signingAlgorithm = mapped
    }

    internal fun build(): AS2ValidationSettingsArgs = AS2ValidationSettingsArgs(
        checkCertificateRevocationListOnReceive = checkCertificateRevocationListOnReceive ?: throw
            PulumiNullFieldException("checkCertificateRevocationListOnReceive"),
        checkCertificateRevocationListOnSend = checkCertificateRevocationListOnSend ?: throw
            PulumiNullFieldException("checkCertificateRevocationListOnSend"),
        checkDuplicateMessage = checkDuplicateMessage ?: throw
            PulumiNullFieldException("checkDuplicateMessage"),
        compressMessage = compressMessage ?: throw PulumiNullFieldException("compressMessage"),
        encryptMessage = encryptMessage ?: throw PulumiNullFieldException("encryptMessage"),
        encryptionAlgorithm = encryptionAlgorithm ?: throw PulumiNullFieldException("encryptionAlgorithm"),
        interchangeDuplicatesValidityDays = interchangeDuplicatesValidityDays ?: throw
            PulumiNullFieldException("interchangeDuplicatesValidityDays"),
        overrideMessageProperties = overrideMessageProperties ?: throw
            PulumiNullFieldException("overrideMessageProperties"),
        signMessage = signMessage ?: throw PulumiNullFieldException("signMessage"),
        signingAlgorithm = signingAlgorithm,
    )
}
