@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.AgreementContentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The integration account agreement content.
 * @property aS2 The AS2 agreement content.
 * @property edifact The EDIFACT agreement content.
 * @property x12 The X12 agreement content.
 */
public data class AgreementContentArgs(
    public val aS2: Output<AS2AgreementContentArgs>? = null,
    public val edifact: Output<EdifactAgreementContentArgs>? = null,
    public val x12: Output<X12AgreementContentArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.AgreementContentArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.AgreementContentArgs =
        com.pulumi.azurenative.logic.inputs.AgreementContentArgs.builder()
            .aS2(aS2?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .edifact(edifact?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .x12(x12?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AgreementContentArgs].
 */
@PulumiTagMarker
public class AgreementContentArgsBuilder internal constructor() {
    private var aS2: Output<AS2AgreementContentArgs>? = null

    private var edifact: Output<EdifactAgreementContentArgs>? = null

    private var x12: Output<X12AgreementContentArgs>? = null

    /**
     * @param value The AS2 agreement content.
     */
    @JvmName("pcssrfguaqtyqkbj")
    public suspend fun aS2(`value`: Output<AS2AgreementContentArgs>) {
        this.aS2 = value
    }

    /**
     * @param value The EDIFACT agreement content.
     */
    @JvmName("amdpkjpggqcpqsvy")
    public suspend fun edifact(`value`: Output<EdifactAgreementContentArgs>) {
        this.edifact = value
    }

    /**
     * @param value The X12 agreement content.
     */
    @JvmName("eytlsoorallveikx")
    public suspend fun x12(`value`: Output<X12AgreementContentArgs>) {
        this.x12 = value
    }

    /**
     * @param value The AS2 agreement content.
     */
    @JvmName("wgubpnttsyboxlht")
    public suspend fun aS2(`value`: AS2AgreementContentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aS2 = mapped
    }

    /**
     * @param argument The AS2 agreement content.
     */
    @JvmName("sqctqkhqliqnqlxa")
    public suspend fun aS2(argument: suspend AS2AgreementContentArgsBuilder.() -> Unit) {
        val toBeMapped = AS2AgreementContentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.aS2 = mapped
    }

    /**
     * @param value The EDIFACT agreement content.
     */
    @JvmName("xbtkerlivtiihqyw")
    public suspend fun edifact(`value`: EdifactAgreementContentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edifact = mapped
    }

    /**
     * @param argument The EDIFACT agreement content.
     */
    @JvmName("bmvflllkccmsnyux")
    public suspend fun edifact(argument: suspend EdifactAgreementContentArgsBuilder.() -> Unit) {
        val toBeMapped = EdifactAgreementContentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.edifact = mapped
    }

    /**
     * @param value The X12 agreement content.
     */
    @JvmName("fkhkppekllbflbla")
    public suspend fun x12(`value`: X12AgreementContentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.x12 = mapped
    }

    /**
     * @param argument The X12 agreement content.
     */
    @JvmName("kordhpgfxaylkojg")
    public suspend fun x12(argument: suspend X12AgreementContentArgsBuilder.() -> Unit) {
        val toBeMapped = X12AgreementContentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.x12 = mapped
    }

    internal fun build(): AgreementContentArgs = AgreementContentArgs(
        aS2 = aS2,
        edifact = edifact,
        x12 = x12,
    )
}
