@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.BatchConfigurationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The batch configuration properties definition.
 * @property batchGroupName The name of the batch group.
 * @property changedTime The artifact changed time.
 * @property createdTime The artifact creation time.
 * @property metadata
 * @property releaseCriteria The batch release criteria.
 */
public data class BatchConfigurationPropertiesArgs(
    public val batchGroupName: Output<String>,
    public val changedTime: Output<String>? = null,
    public val createdTime: Output<String>? = null,
    public val metadata: Output<Any>? = null,
    public val releaseCriteria: Output<BatchReleaseCriteriaArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.BatchConfigurationPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.BatchConfigurationPropertiesArgs =
        com.pulumi.azurenative.logic.inputs.BatchConfigurationPropertiesArgs.builder()
            .batchGroupName(batchGroupName.applyValue({ args0 -> args0 }))
            .changedTime(changedTime?.applyValue({ args0 -> args0 }))
            .createdTime(createdTime?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .releaseCriteria(
                releaseCriteria.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [BatchConfigurationPropertiesArgs].
 */
@PulumiTagMarker
public class BatchConfigurationPropertiesArgsBuilder internal constructor() {
    private var batchGroupName: Output<String>? = null

    private var changedTime: Output<String>? = null

    private var createdTime: Output<String>? = null

    private var metadata: Output<Any>? = null

    private var releaseCriteria: Output<BatchReleaseCriteriaArgs>? = null

    /**
     * @param value The name of the batch group.
     */
    @JvmName("aetexiewovdmoglu")
    public suspend fun batchGroupName(`value`: Output<String>) {
        this.batchGroupName = value
    }

    /**
     * @param value The artifact changed time.
     */
    @JvmName("kwvuwlndskkmagte")
    public suspend fun changedTime(`value`: Output<String>) {
        this.changedTime = value
    }

    /**
     * @param value The artifact creation time.
     */
    @JvmName("wyvemnwvuxdgppeo")
    public suspend fun createdTime(`value`: Output<String>) {
        this.createdTime = value
    }

    /**
     * @param value
     */
    @JvmName("qdpalqnaqentlcin")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The batch release criteria.
     */
    @JvmName("lxmfvtsvwfcrjeos")
    public suspend fun releaseCriteria(`value`: Output<BatchReleaseCriteriaArgs>) {
        this.releaseCriteria = value
    }

    /**
     * @param value The name of the batch group.
     */
    @JvmName("yhmaailunqegodxb")
    public suspend fun batchGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.batchGroupName = mapped
    }

    /**
     * @param value The artifact changed time.
     */
    @JvmName("vkcxyqvueqwbyvkh")
    public suspend fun changedTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changedTime = mapped
    }

    /**
     * @param value The artifact creation time.
     */
    @JvmName("rbgslrvdbavrewuf")
    public suspend fun createdTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("vbgybfepxdyfeqhx")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The batch release criteria.
     */
    @JvmName("oxrwwpsxyjmxbbos")
    public suspend fun releaseCriteria(`value`: BatchReleaseCriteriaArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.releaseCriteria = mapped
    }

    /**
     * @param argument The batch release criteria.
     */
    @JvmName("amiikmajqhhdxpgg")
    public suspend fun releaseCriteria(argument: suspend BatchReleaseCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped = BatchReleaseCriteriaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.releaseCriteria = mapped
    }

    internal fun build(): BatchConfigurationPropertiesArgs = BatchConfigurationPropertiesArgs(
        batchGroupName = batchGroupName ?: throw PulumiNullFieldException("batchGroupName"),
        changedTime = changedTime,
        createdTime = createdTime,
        metadata = metadata,
        releaseCriteria = releaseCriteria ?: throw PulumiNullFieldException("releaseCriteria"),
    )
}
