@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.BatchReleaseCriteriaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The batch release criteria.
 * @property batchSize The batch size in bytes.
 * @property messageCount The message count.
 * @property recurrence The recurrence.
 */
public data class BatchReleaseCriteriaArgs(
    public val batchSize: Output<Int>? = null,
    public val messageCount: Output<Int>? = null,
    public val recurrence: Output<WorkflowTriggerRecurrenceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.BatchReleaseCriteriaArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.BatchReleaseCriteriaArgs =
        com.pulumi.azurenative.logic.inputs.BatchReleaseCriteriaArgs.builder()
            .batchSize(batchSize?.applyValue({ args0 -> args0 }))
            .messageCount(messageCount?.applyValue({ args0 -> args0 }))
            .recurrence(recurrence?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BatchReleaseCriteriaArgs].
 */
@PulumiTagMarker
public class BatchReleaseCriteriaArgsBuilder internal constructor() {
    private var batchSize: Output<Int>? = null

    private var messageCount: Output<Int>? = null

    private var recurrence: Output<WorkflowTriggerRecurrenceArgs>? = null

    /**
     * @param value The batch size in bytes.
     */
    @JvmName("bnfwqcfdalxiaueg")
    public suspend fun batchSize(`value`: Output<Int>) {
        this.batchSize = value
    }

    /**
     * @param value The message count.
     */
    @JvmName("eogtnybxlgqiacfv")
    public suspend fun messageCount(`value`: Output<Int>) {
        this.messageCount = value
    }

    /**
     * @param value The recurrence.
     */
    @JvmName("aailnyanpwftigrt")
    public suspend fun recurrence(`value`: Output<WorkflowTriggerRecurrenceArgs>) {
        this.recurrence = value
    }

    /**
     * @param value The batch size in bytes.
     */
    @JvmName("vnvdxylpdekrqmlr")
    public suspend fun batchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchSize = mapped
    }

    /**
     * @param value The message count.
     */
    @JvmName("blauxppjumixbdyy")
    public suspend fun messageCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageCount = mapped
    }

    /**
     * @param value The recurrence.
     */
    @JvmName("qtjgmlsibragmfla")
    public suspend fun recurrence(`value`: WorkflowTriggerRecurrenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrence = mapped
    }

    /**
     * @param argument The recurrence.
     */
    @JvmName("vlvwrwlphxwptpss")
    public suspend fun recurrence(argument: suspend WorkflowTriggerRecurrenceArgsBuilder.() -> Unit) {
        val toBeMapped = WorkflowTriggerRecurrenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.recurrence = mapped
    }

    internal fun build(): BatchReleaseCriteriaArgs = BatchReleaseCriteriaArgs(
        batchSize = batchSize,
        messageCount = messageCount,
        recurrence = recurrence,
    )
}
