@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.ContentLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The content link.
 * @property uri The content link URI.
 */
public data class ContentLinkArgs(
    public val uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.ContentLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.ContentLinkArgs =
        com.pulumi.azurenative.logic.inputs.ContentLinkArgs.builder()
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentLinkArgs].
 */
@PulumiTagMarker
public class ContentLinkArgsBuilder internal constructor() {
    private var uri: Output<String>? = null

    /**
     * @param value The content link URI.
     */
    @JvmName("iqrnbvgnrkrkvtus")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The content link URI.
     */
    @JvmName("ygwxhgfbjwrjhpbi")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): ContentLinkArgs = ContentLinkArgs(
        uri = uri,
    )
}
