@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.EdifactAgreementContentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Edifact agreement content.
 * @property receiveAgreement The EDIFACT one-way receive agreement.
 * @property sendAgreement The EDIFACT one-way send agreement.
 */
public data class EdifactAgreementContentArgs(
    public val receiveAgreement: Output<EdifactOneWayAgreementArgs>,
    public val sendAgreement: Output<EdifactOneWayAgreementArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.EdifactAgreementContentArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.EdifactAgreementContentArgs =
        com.pulumi.azurenative.logic.inputs.EdifactAgreementContentArgs.builder()
            .receiveAgreement(receiveAgreement.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sendAgreement(sendAgreement.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EdifactAgreementContentArgs].
 */
@PulumiTagMarker
public class EdifactAgreementContentArgsBuilder internal constructor() {
    private var receiveAgreement: Output<EdifactOneWayAgreementArgs>? = null

    private var sendAgreement: Output<EdifactOneWayAgreementArgs>? = null

    /**
     * @param value The EDIFACT one-way receive agreement.
     */
    @JvmName("hcwfpvywbcnhbraj")
    public suspend fun receiveAgreement(`value`: Output<EdifactOneWayAgreementArgs>) {
        this.receiveAgreement = value
    }

    /**
     * @param value The EDIFACT one-way send agreement.
     */
    @JvmName("eyfrholwccprgwpw")
    public suspend fun sendAgreement(`value`: Output<EdifactOneWayAgreementArgs>) {
        this.sendAgreement = value
    }

    /**
     * @param value The EDIFACT one-way receive agreement.
     */
    @JvmName("bunhmtsawtpqgtqa")
    public suspend fun receiveAgreement(`value`: EdifactOneWayAgreementArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.receiveAgreement = mapped
    }

    /**
     * @param argument The EDIFACT one-way receive agreement.
     */
    @JvmName("gaihccsnpwldwcqj")
    public suspend fun receiveAgreement(argument: suspend EdifactOneWayAgreementArgsBuilder.() -> Unit) {
        val toBeMapped = EdifactOneWayAgreementArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.receiveAgreement = mapped
    }

    /**
     * @param value The EDIFACT one-way send agreement.
     */
    @JvmName("pxlsggxgaghhcaox")
    public suspend fun sendAgreement(`value`: EdifactOneWayAgreementArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sendAgreement = mapped
    }

    /**
     * @param argument The EDIFACT one-way send agreement.
     */
    @JvmName("cvmyijnehlkropll")
    public suspend fun sendAgreement(argument: suspend EdifactOneWayAgreementArgsBuilder.() -> Unit) {
        val toBeMapped = EdifactOneWayAgreementArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sendAgreement = mapped
    }

    internal fun build(): EdifactAgreementContentArgs = EdifactAgreementContentArgs(
        receiveAgreement = receiveAgreement ?: throw PulumiNullFieldException("receiveAgreement"),
        sendAgreement = sendAgreement ?: throw PulumiNullFieldException("sendAgreement"),
    )
}
