@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.EdifactEnvelopeOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Edifact envelope override settings.
 * @property applicationPassword The application password.
 * @property associationAssignedCode The association assigned code.
 * @property controllingAgencyCode The controlling agency code.
 * @property functionalGroupId The functional group id.
 * @property groupHeaderMessageRelease The group header message release.
 * @property groupHeaderMessageVersion The group header message version.
 * @property messageAssociationAssignedCode The message association assigned code.
 * @property messageId The message id on which this envelope settings has to be applied.
 * @property messageRelease The message release version on which this envelope settings has to be applied.
 * @property messageVersion The message version on which this envelope settings has to be applied.
 * @property receiverApplicationId The receiver application id.
 * @property receiverApplicationQualifier The receiver application qualifier.
 * @property senderApplicationId The sender application id.
 * @property senderApplicationQualifier The sender application qualifier.
 * @property targetNamespace The target namespace on which this envelope settings has to be applied.
 */
public data class EdifactEnvelopeOverrideArgs(
    public val applicationPassword: Output<String>? = null,
    public val associationAssignedCode: Output<String>? = null,
    public val controllingAgencyCode: Output<String>? = null,
    public val functionalGroupId: Output<String>? = null,
    public val groupHeaderMessageRelease: Output<String>? = null,
    public val groupHeaderMessageVersion: Output<String>? = null,
    public val messageAssociationAssignedCode: Output<String>? = null,
    public val messageId: Output<String>? = null,
    public val messageRelease: Output<String>? = null,
    public val messageVersion: Output<String>? = null,
    public val receiverApplicationId: Output<String>? = null,
    public val receiverApplicationQualifier: Output<String>? = null,
    public val senderApplicationId: Output<String>? = null,
    public val senderApplicationQualifier: Output<String>? = null,
    public val targetNamespace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.EdifactEnvelopeOverrideArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.EdifactEnvelopeOverrideArgs =
        com.pulumi.azurenative.logic.inputs.EdifactEnvelopeOverrideArgs.builder()
            .applicationPassword(applicationPassword?.applyValue({ args0 -> args0 }))
            .associationAssignedCode(associationAssignedCode?.applyValue({ args0 -> args0 }))
            .controllingAgencyCode(controllingAgencyCode?.applyValue({ args0 -> args0 }))
            .functionalGroupId(functionalGroupId?.applyValue({ args0 -> args0 }))
            .groupHeaderMessageRelease(groupHeaderMessageRelease?.applyValue({ args0 -> args0 }))
            .groupHeaderMessageVersion(groupHeaderMessageVersion?.applyValue({ args0 -> args0 }))
            .messageAssociationAssignedCode(messageAssociationAssignedCode?.applyValue({ args0 -> args0 }))
            .messageId(messageId?.applyValue({ args0 -> args0 }))
            .messageRelease(messageRelease?.applyValue({ args0 -> args0 }))
            .messageVersion(messageVersion?.applyValue({ args0 -> args0 }))
            .receiverApplicationId(receiverApplicationId?.applyValue({ args0 -> args0 }))
            .receiverApplicationQualifier(receiverApplicationQualifier?.applyValue({ args0 -> args0 }))
            .senderApplicationId(senderApplicationId?.applyValue({ args0 -> args0 }))
            .senderApplicationQualifier(senderApplicationQualifier?.applyValue({ args0 -> args0 }))
            .targetNamespace(targetNamespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EdifactEnvelopeOverrideArgs].
 */
@PulumiTagMarker
public class EdifactEnvelopeOverrideArgsBuilder internal constructor() {
    private var applicationPassword: Output<String>? = null

    private var associationAssignedCode: Output<String>? = null

    private var controllingAgencyCode: Output<String>? = null

    private var functionalGroupId: Output<String>? = null

    private var groupHeaderMessageRelease: Output<String>? = null

    private var groupHeaderMessageVersion: Output<String>? = null

    private var messageAssociationAssignedCode: Output<String>? = null

    private var messageId: Output<String>? = null

    private var messageRelease: Output<String>? = null

    private var messageVersion: Output<String>? = null

    private var receiverApplicationId: Output<String>? = null

    private var receiverApplicationQualifier: Output<String>? = null

    private var senderApplicationId: Output<String>? = null

    private var senderApplicationQualifier: Output<String>? = null

    private var targetNamespace: Output<String>? = null

    /**
     * @param value The application password.
     */
    @JvmName("iyhwvpiicxmbugff")
    public suspend fun applicationPassword(`value`: Output<String>) {
        this.applicationPassword = value
    }

    /**
     * @param value The association assigned code.
     */
    @JvmName("dqqlfpiymfesrljh")
    public suspend fun associationAssignedCode(`value`: Output<String>) {
        this.associationAssignedCode = value
    }

    /**
     * @param value The controlling agency code.
     */
    @JvmName("ifksxcbfxwfugiws")
    public suspend fun controllingAgencyCode(`value`: Output<String>) {
        this.controllingAgencyCode = value
    }

    /**
     * @param value The functional group id.
     */
    @JvmName("dyekivdhsnjrbpqk")
    public suspend fun functionalGroupId(`value`: Output<String>) {
        this.functionalGroupId = value
    }

    /**
     * @param value The group header message release.
     */
    @JvmName("pncbitnxgbtclycp")
    public suspend fun groupHeaderMessageRelease(`value`: Output<String>) {
        this.groupHeaderMessageRelease = value
    }

    /**
     * @param value The group header message version.
     */
    @JvmName("gcqukmlpvdwjnkrs")
    public suspend fun groupHeaderMessageVersion(`value`: Output<String>) {
        this.groupHeaderMessageVersion = value
    }

    /**
     * @param value The message association assigned code.
     */
    @JvmName("pnrgmxaepqxghqbi")
    public suspend fun messageAssociationAssignedCode(`value`: Output<String>) {
        this.messageAssociationAssignedCode = value
    }

    /**
     * @param value The message id on which this envelope settings has to be applied.
     */
    @JvmName("xmgxywfsogandrqq")
    public suspend fun messageId(`value`: Output<String>) {
        this.messageId = value
    }

    /**
     * @param value The message release version on which this envelope settings has to be applied.
     */
    @JvmName("plvigfbycnlwnqlp")
    public suspend fun messageRelease(`value`: Output<String>) {
        this.messageRelease = value
    }

    /**
     * @param value The message version on which this envelope settings has to be applied.
     */
    @JvmName("uigulwhrbissddbr")
    public suspend fun messageVersion(`value`: Output<String>) {
        this.messageVersion = value
    }

    /**
     * @param value The receiver application id.
     */
    @JvmName("khedpodhdtkyparf")
    public suspend fun receiverApplicationId(`value`: Output<String>) {
        this.receiverApplicationId = value
    }

    /**
     * @param value The receiver application qualifier.
     */
    @JvmName("iuvbyxpbtoaimwwj")
    public suspend fun receiverApplicationQualifier(`value`: Output<String>) {
        this.receiverApplicationQualifier = value
    }

    /**
     * @param value The sender application id.
     */
    @JvmName("oplwdjlrayoejucq")
    public suspend fun senderApplicationId(`value`: Output<String>) {
        this.senderApplicationId = value
    }

    /**
     * @param value The sender application qualifier.
     */
    @JvmName("vktxwvgqfudcisxo")
    public suspend fun senderApplicationQualifier(`value`: Output<String>) {
        this.senderApplicationQualifier = value
    }

    /**
     * @param value The target namespace on which this envelope settings has to be applied.
     */
    @JvmName("xyfbhvathrlreksc")
    public suspend fun targetNamespace(`value`: Output<String>) {
        this.targetNamespace = value
    }

    /**
     * @param value The application password.
     */
    @JvmName("qfqmcobplmtcrjur")
    public suspend fun applicationPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationPassword = mapped
    }

    /**
     * @param value The association assigned code.
     */
    @JvmName("uxyccmpyqknixsda")
    public suspend fun associationAssignedCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associationAssignedCode = mapped
    }

    /**
     * @param value The controlling agency code.
     */
    @JvmName("baoeulhqrvrfraou")
    public suspend fun controllingAgencyCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controllingAgencyCode = mapped
    }

    /**
     * @param value The functional group id.
     */
    @JvmName("pogawjvrwflmvqta")
    public suspend fun functionalGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionalGroupId = mapped
    }

    /**
     * @param value The group header message release.
     */
    @JvmName("ggrvmeotnlwgdybg")
    public suspend fun groupHeaderMessageRelease(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupHeaderMessageRelease = mapped
    }

    /**
     * @param value The group header message version.
     */
    @JvmName("hlsikxhnjqqcmxfx")
    public suspend fun groupHeaderMessageVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupHeaderMessageVersion = mapped
    }

    /**
     * @param value The message association assigned code.
     */
    @JvmName("naflifxxwbiwudyh")
    public suspend fun messageAssociationAssignedCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageAssociationAssignedCode = mapped
    }

    /**
     * @param value The message id on which this envelope settings has to be applied.
     */
    @JvmName("hsukgymcnkhxxsim")
    public suspend fun messageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageId = mapped
    }

    /**
     * @param value The message release version on which this envelope settings has to be applied.
     */
    @JvmName("vavytscwemhaxwus")
    public suspend fun messageRelease(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageRelease = mapped
    }

    /**
     * @param value The message version on which this envelope settings has to be applied.
     */
    @JvmName("asoskctdafhkopty")
    public suspend fun messageVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageVersion = mapped
    }

    /**
     * @param value The receiver application id.
     */
    @JvmName("jjjlidefgvulwugj")
    public suspend fun receiverApplicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.receiverApplicationId = mapped
    }

    /**
     * @param value The receiver application qualifier.
     */
    @JvmName("elgabhwyqblyckbl")
    public suspend fun receiverApplicationQualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.receiverApplicationQualifier = mapped
    }

    /**
     * @param value The sender application id.
     */
    @JvmName("gbhhuvbyjnjteffn")
    public suspend fun senderApplicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.senderApplicationId = mapped
    }

    /**
     * @param value The sender application qualifier.
     */
    @JvmName("shatajvveijgpwgj")
    public suspend fun senderApplicationQualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.senderApplicationQualifier = mapped
    }

    /**
     * @param value The target namespace on which this envelope settings has to be applied.
     */
    @JvmName("ecnmvroxkanousbc")
    public suspend fun targetNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetNamespace = mapped
    }

    internal fun build(): EdifactEnvelopeOverrideArgs = EdifactEnvelopeOverrideArgs(
        applicationPassword = applicationPassword,
        associationAssignedCode = associationAssignedCode,
        controllingAgencyCode = controllingAgencyCode,
        functionalGroupId = functionalGroupId,
        groupHeaderMessageRelease = groupHeaderMessageRelease,
        groupHeaderMessageVersion = groupHeaderMessageVersion,
        messageAssociationAssignedCode = messageAssociationAssignedCode,
        messageId = messageId,
        messageRelease = messageRelease,
        messageVersion = messageVersion,
        receiverApplicationId = receiverApplicationId,
        receiverApplicationQualifier = receiverApplicationQualifier,
        senderApplicationId = senderApplicationId,
        senderApplicationQualifier = senderApplicationQualifier,
        targetNamespace = targetNamespace,
    )
}
