@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.FlowAccessControlConfigurationPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The access control configuration policy.
 * @property allowedCallerIpAddresses The allowed caller IP address ranges.
 * @property openAuthenticationPolicies The authentication policies for workflow.
 */
public data class FlowAccessControlConfigurationPolicyArgs(
    public val allowedCallerIpAddresses: Output<List<IpAddressRangeArgs>>? = null,
    public val openAuthenticationPolicies: Output<OpenAuthenticationAccessPoliciesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.FlowAccessControlConfigurationPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.FlowAccessControlConfigurationPolicyArgs =
        com.pulumi.azurenative.logic.inputs.FlowAccessControlConfigurationPolicyArgs.builder()
            .allowedCallerIpAddresses(
                allowedCallerIpAddresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .openAuthenticationPolicies(
                openAuthenticationPolicies?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [FlowAccessControlConfigurationPolicyArgs].
 */
@PulumiTagMarker
public class FlowAccessControlConfigurationPolicyArgsBuilder internal constructor() {
    private var allowedCallerIpAddresses: Output<List<IpAddressRangeArgs>>? = null

    private var openAuthenticationPolicies: Output<OpenAuthenticationAccessPoliciesArgs>? = null

    /**
     * @param value The allowed caller IP address ranges.
     */
    @JvmName("hgutuwfhowpkecbq")
    public suspend fun allowedCallerIpAddresses(`value`: Output<List<IpAddressRangeArgs>>) {
        this.allowedCallerIpAddresses = value
    }

    @JvmName("kflnyfcfibxsmrfk")
    public suspend fun allowedCallerIpAddresses(vararg values: Output<IpAddressRangeArgs>) {
        this.allowedCallerIpAddresses = Output.all(values.asList())
    }

    /**
     * @param values The allowed caller IP address ranges.
     */
    @JvmName("vlhtwjuqitcnyyly")
    public suspend fun allowedCallerIpAddresses(values: List<Output<IpAddressRangeArgs>>) {
        this.allowedCallerIpAddresses = Output.all(values)
    }

    /**
     * @param value The authentication policies for workflow.
     */
    @JvmName("exqaaawxpyromckv")
    public suspend fun openAuthenticationPolicies(`value`: Output<OpenAuthenticationAccessPoliciesArgs>) {
        this.openAuthenticationPolicies = value
    }

    /**
     * @param value The allowed caller IP address ranges.
     */
    @JvmName("panasfjdgabhkshh")
    public suspend fun allowedCallerIpAddresses(`value`: List<IpAddressRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedCallerIpAddresses = mapped
    }

    /**
     * @param argument The allowed caller IP address ranges.
     */
    @JvmName("hlkuljucqffsntof")
    public suspend fun allowedCallerIpAddresses(argument: List<suspend IpAddressRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IpAddressRangeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.allowedCallerIpAddresses = mapped
    }

    /**
     * @param argument The allowed caller IP address ranges.
     */
    @JvmName("fcquopwwhwgkbhwo")
    public suspend fun allowedCallerIpAddresses(vararg argument: suspend IpAddressRangeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IpAddressRangeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.allowedCallerIpAddresses = mapped
    }

    /**
     * @param argument The allowed caller IP address ranges.
     */
    @JvmName("bkytksnofowfbiwj")
    public suspend fun allowedCallerIpAddresses(argument: suspend IpAddressRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpAddressRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.allowedCallerIpAddresses = mapped
    }

    /**
     * @param values The allowed caller IP address ranges.
     */
    @JvmName("injearhowkgrawrh")
    public suspend fun allowedCallerIpAddresses(vararg values: IpAddressRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedCallerIpAddresses = mapped
    }

    /**
     * @param value The authentication policies for workflow.
     */
    @JvmName("touopbdmsbvqdyic")
    public suspend fun openAuthenticationPolicies(`value`: OpenAuthenticationAccessPoliciesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openAuthenticationPolicies = mapped
    }

    /**
     * @param argument The authentication policies for workflow.
     */
    @JvmName("rfxvufcxdunivvlm")
    public suspend fun openAuthenticationPolicies(argument: suspend OpenAuthenticationAccessPoliciesArgsBuilder.() -> Unit) {
        val toBeMapped = OpenAuthenticationAccessPoliciesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.openAuthenticationPolicies = mapped
    }

    internal fun build(): FlowAccessControlConfigurationPolicyArgs =
        FlowAccessControlConfigurationPolicyArgs(
            allowedCallerIpAddresses = allowedCallerIpAddresses,
            openAuthenticationPolicies = openAuthenticationPolicies,
        )
}
