@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.GetIntegrationAccountAgreementPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property agreementName The integration account agreement name.
 * @property integrationAccountName The integration account name.
 * @property resourceGroupName The resource group name.
 */
public data class GetIntegrationAccountAgreementPlainArgs(
    public val agreementName: String,
    public val integrationAccountName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.GetIntegrationAccountAgreementPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.GetIntegrationAccountAgreementPlainArgs = com.pulumi.azurenative.logic.inputs.GetIntegrationAccountAgreementPlainArgs.builder()
        .agreementName(agreementName.let({ args0 -> args0 }))
        .integrationAccountName(integrationAccountName.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIntegrationAccountAgreementPlainArgs].
 */
@PulumiTagMarker
public class GetIntegrationAccountAgreementPlainArgsBuilder internal constructor() {
    private var agreementName: String? = null

    private var integrationAccountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The integration account agreement name.
     */
    @JvmName("gqmpfgufnapdyiqo")
    public suspend fun agreementName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.agreementName = mapped
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("tjymjhddxeijvdad")
    public suspend fun integrationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("uwpmmctkfybewicw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetIntegrationAccountAgreementPlainArgs =
        GetIntegrationAccountAgreementPlainArgs(
            agreementName = agreementName ?: throw PulumiNullFieldException("agreementName"),
            integrationAccountName = integrationAccountName ?: throw
                PulumiNullFieldException("integrationAccountName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
