@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.GetIntegrationAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property integrationAccountName The integration account name.
 * @property resourceGroupName The resource group name.
 */
public data class GetIntegrationAccountPlainArgs(
    public val integrationAccountName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.GetIntegrationAccountPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.GetIntegrationAccountPlainArgs =
        com.pulumi.azurenative.logic.inputs.GetIntegrationAccountPlainArgs.builder()
            .integrationAccountName(integrationAccountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIntegrationAccountPlainArgs].
 */
@PulumiTagMarker
public class GetIntegrationAccountPlainArgsBuilder internal constructor() {
    private var integrationAccountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The integration account name.
     */
    @JvmName("mrkeqdqkpvwoithv")
    public suspend fun integrationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("bthgloltjojtssfr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetIntegrationAccountPlainArgs = GetIntegrationAccountPlainArgs(
        integrationAccountName = integrationAccountName ?: throw
            PulumiNullFieldException("integrationAccountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
