@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.IntegrationAccountSkuArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.IntegrationAccountSkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The integration account sku.
 * @property name The sku name.
 */
public data class IntegrationAccountSkuArgs(
    public val name: Output<Either<String, IntegrationAccountSkuName>>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.IntegrationAccountSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.IntegrationAccountSkuArgs =
        com.pulumi.azurenative.logic.inputs.IntegrationAccountSkuArgs.builder()
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IntegrationAccountSkuArgs].
 */
@PulumiTagMarker
public class IntegrationAccountSkuArgsBuilder internal constructor() {
    private var name: Output<Either<String, IntegrationAccountSkuName>>? = null

    /**
     * @param value The sku name.
     */
    @JvmName("dngrfwronmkhddkd")
    public suspend fun name(`value`: Output<Either<String, IntegrationAccountSkuName>>) {
        this.name = value
    }

    /**
     * @param value The sku name.
     */
    @JvmName("vagprositirabbbk")
    public suspend fun name(`value`: Either<String, IntegrationAccountSkuName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The sku name.
     */
    @JvmName("tyowmesaatmuqbos")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IntegrationAccountSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The sku name.
     */
    @JvmName("ltbfxgohsuesknkc")
    public fun name(`value`: IntegrationAccountSkuName) {
        val toBeMapped = Either.ofRight<String, IntegrationAccountSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): IntegrationAccountSkuArgs = IntegrationAccountSkuArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
