@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmenEncryptionKeyReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The encryption key details for the integration service environment.
 * @property keyName Gets the key name in the Key Vault.
 * @property keyVault The key vault reference.
 * @property keyVersion Gets the version of the key specified in the keyName property.
 */
public data class IntegrationServiceEnvironmenEncryptionKeyReferenceArgs(
    public val keyName: Output<String>? = null,
    public val keyVault: Output<ResourceReferenceArgs>? = null,
    public val keyVersion: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmenEncryptionKeyReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmenEncryptionKeyReferenceArgs =
        com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmenEncryptionKeyReferenceArgs.builder()
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .keyVault(keyVault?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyVersion(keyVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationServiceEnvironmenEncryptionKeyReferenceArgs].
 */
@PulumiTagMarker
public class IntegrationServiceEnvironmenEncryptionKeyReferenceArgsBuilder internal constructor() {
    private var keyName: Output<String>? = null

    private var keyVault: Output<ResourceReferenceArgs>? = null

    private var keyVersion: Output<String>? = null

    /**
     * @param value Gets the key name in the Key Vault.
     */
    @JvmName("hxxmswfiegmqmumy")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The key vault reference.
     */
    @JvmName("nduaoymgivcceqgh")
    public suspend fun keyVault(`value`: Output<ResourceReferenceArgs>) {
        this.keyVault = value
    }

    /**
     * @param value Gets the version of the key specified in the keyName property.
     */
    @JvmName("dwgxjipxpcrdjutd")
    public suspend fun keyVersion(`value`: Output<String>) {
        this.keyVersion = value
    }

    /**
     * @param value Gets the key name in the Key Vault.
     */
    @JvmName("ghjspbnknekxkvos")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The key vault reference.
     */
    @JvmName("bjfbwgqgaoqoketa")
    public suspend fun keyVault(`value`: ResourceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVault = mapped
    }

    /**
     * @param argument The key vault reference.
     */
    @JvmName("vthssyrevlrpyqvh")
    public suspend fun keyVault(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVault = mapped
    }

    /**
     * @param value Gets the version of the key specified in the keyName property.
     */
    @JvmName("xrayrssvplpnmuuh")
    public suspend fun keyVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVersion = mapped
    }

    internal fun build(): IntegrationServiceEnvironmenEncryptionKeyReferenceArgs =
        IntegrationServiceEnvironmenEncryptionKeyReferenceArgs(
            keyName = keyName,
            keyVault = keyVault,
            keyVersion = keyVersion,
        )
}
