@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmentPropertiesArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.WorkflowProvisioningState
import com.pulumi.azurenative.logic.kotlin.enums.WorkflowState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The integration service environment properties.
 * @property encryptionConfiguration The encryption configuration.
 * @property endpointsConfiguration The endpoints configuration.
 * @property integrationServiceEnvironmentId Gets the tracking id.
 * @property networkConfiguration The network configuration.
 * @property provisioningState The provisioning state.
 * @property state The integration service environment state.
 */
public data class IntegrationServiceEnvironmentPropertiesArgs(
    public val encryptionConfiguration: Output<IntegrationServiceEnvironmenEncryptionConfigurationArgs>? = null,
    public val endpointsConfiguration: Output<FlowEndpointsConfigurationArgs>? = null,
    public val integrationServiceEnvironmentId: Output<String>? = null,
    public val networkConfiguration: Output<NetworkConfigurationArgs>? = null,
    public val provisioningState: Output<Either<String, WorkflowProvisioningState>>? = null,
    public val state: Output<Either<String, WorkflowState>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmentPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmentPropertiesArgs =
        com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmentPropertiesArgs.builder()
            .encryptionConfiguration(
                encryptionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .endpointsConfiguration(
                endpointsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .integrationServiceEnvironmentId(integrationServiceEnvironmentId?.applyValue({ args0 -> args0 }))
            .networkConfiguration(
                networkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IntegrationServiceEnvironmentPropertiesArgs].
 */
@PulumiTagMarker
public class IntegrationServiceEnvironmentPropertiesArgsBuilder internal constructor() {
    private var encryptionConfiguration:
        Output<IntegrationServiceEnvironmenEncryptionConfigurationArgs>? = null

    private var endpointsConfiguration: Output<FlowEndpointsConfigurationArgs>? = null

    private var integrationServiceEnvironmentId: Output<String>? = null

    private var networkConfiguration: Output<NetworkConfigurationArgs>? = null

    private var provisioningState: Output<Either<String, WorkflowProvisioningState>>? = null

    private var state: Output<Either<String, WorkflowState>>? = null

    /**
     * @param value The encryption configuration.
     */
    @JvmName("ttcioqlulbrybhsb")
    public suspend fun encryptionConfiguration(`value`: Output<IntegrationServiceEnvironmenEncryptionConfigurationArgs>) {
        this.encryptionConfiguration = value
    }

    /**
     * @param value The endpoints configuration.
     */
    @JvmName("jpycwixgktyvqyuc")
    public suspend fun endpointsConfiguration(`value`: Output<FlowEndpointsConfigurationArgs>) {
        this.endpointsConfiguration = value
    }

    /**
     * @param value Gets the tracking id.
     */
    @JvmName("dwcoqkulvhwabbhw")
    public suspend fun integrationServiceEnvironmentId(`value`: Output<String>) {
        this.integrationServiceEnvironmentId = value
    }

    /**
     * @param value The network configuration.
     */
    @JvmName("bbydglurmvfmukul")
    public suspend fun networkConfiguration(`value`: Output<NetworkConfigurationArgs>) {
        this.networkConfiguration = value
    }

    /**
     * @param value The provisioning state.
     */
    @JvmName("pboybbplgxyvvuyk")
    public suspend fun provisioningState(`value`: Output<Either<String, WorkflowProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The integration service environment state.
     */
    @JvmName("hcadiorghnimqjvt")
    public suspend fun state(`value`: Output<Either<String, WorkflowState>>) {
        this.state = value
    }

    /**
     * @param value The encryption configuration.
     */
    @JvmName("cnlnuwolqottjiam")
    public suspend fun encryptionConfiguration(`value`: IntegrationServiceEnvironmenEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionConfiguration = mapped
    }

    /**
     * @param argument The encryption configuration.
     */
    @JvmName("rxsrewyhcxmwntgg")
    public suspend fun encryptionConfiguration(argument: suspend IntegrationServiceEnvironmenEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationServiceEnvironmenEncryptionConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.encryptionConfiguration = mapped
    }

    /**
     * @param value The endpoints configuration.
     */
    @JvmName("wdgjslasljfphjky")
    public suspend fun endpointsConfiguration(`value`: FlowEndpointsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointsConfiguration = mapped
    }

    /**
     * @param argument The endpoints configuration.
     */
    @JvmName("pjbdxqranxjjeihh")
    public suspend fun endpointsConfiguration(argument: suspend FlowEndpointsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FlowEndpointsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.endpointsConfiguration = mapped
    }

    /**
     * @param value Gets the tracking id.
     */
    @JvmName("nagyqrtdixvvkfby")
    public suspend fun integrationServiceEnvironmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationServiceEnvironmentId = mapped
    }

    /**
     * @param value The network configuration.
     */
    @JvmName("kpqhqedlcnwjjuxn")
    public suspend fun networkConfiguration(`value`: NetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkConfiguration = mapped
    }

    /**
     * @param argument The network configuration.
     */
    @JvmName("rhcqqmfoxwnlrgdk")
    public suspend fun networkConfiguration(argument: suspend NetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkConfiguration = mapped
    }

    /**
     * @param value The provisioning state.
     */
    @JvmName("ledihxpurbwvkrhm")
    public suspend fun provisioningState(`value`: Either<String, WorkflowProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioning state.
     */
    @JvmName("uvjovrexdrjnbtvl")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WorkflowProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioning state.
     */
    @JvmName("qnjqefeyllklhgqf")
    public fun provisioningState(`value`: WorkflowProvisioningState) {
        val toBeMapped = Either.ofRight<String, WorkflowProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The integration service environment state.
     */
    @JvmName("qurrcbvwehcbeftf")
    public suspend fun state(`value`: Either<String, WorkflowState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The integration service environment state.
     */
    @JvmName("hqdikobkeksoeubt")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WorkflowState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The integration service environment state.
     */
    @JvmName("tpynxtfxivkakqrt")
    public fun state(`value`: WorkflowState) {
        val toBeMapped = Either.ofRight<String, WorkflowState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): IntegrationServiceEnvironmentPropertiesArgs =
        IntegrationServiceEnvironmentPropertiesArgs(
            encryptionConfiguration = encryptionConfiguration,
            endpointsConfiguration = endpointsConfiguration,
            integrationServiceEnvironmentId = integrationServiceEnvironmentId,
            networkConfiguration = networkConfiguration,
            provisioningState = provisioningState,
            state = state,
        )
}
