@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.ListIntegrationAccountCallbackUrlPlainArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.KeyType
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property integrationAccountName The integration account name.
 * @property keyType The key type.
 * @property notAfter The expiry time.
 * @property resourceGroupName The resource group name.
 */
public data class ListIntegrationAccountCallbackUrlPlainArgs(
    public val integrationAccountName: String,
    public val keyType: Either<String, KeyType>? = null,
    public val notAfter: String? = null,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.logic.inputs.ListIntegrationAccountCallbackUrlPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.ListIntegrationAccountCallbackUrlPlainArgs =
        com.pulumi.azurenative.logic.inputs.ListIntegrationAccountCallbackUrlPlainArgs.builder()
            .integrationAccountName(integrationAccountName.let({ args0 -> args0 }))
            .keyType(
                keyType?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .notAfter(notAfter?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListIntegrationAccountCallbackUrlPlainArgs].
 */
@PulumiTagMarker
public class ListIntegrationAccountCallbackUrlPlainArgsBuilder internal constructor() {
    private var integrationAccountName: String? = null

    private var keyType: Either<String, KeyType>? = null

    private var notAfter: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The integration account name.
     */
    @JvmName("mrjsdykgebaprjsw")
    public suspend fun integrationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The key type.
     */
    @JvmName("kqfivxpwvtetoxyh")
    public suspend fun keyType(`value`: Either<String, KeyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The key type.
     */
    @JvmName("stynxjwtprweyqjr")
    public fun keyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KeyType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The key type.
     */
    @JvmName("plnatokksrbnrdqb")
    public fun keyType(`value`: KeyType) {
        val toBeMapped = Either.ofRight<String, KeyType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The expiry time.
     */
    @JvmName("ytrdhucfisimwigc")
    public suspend fun notAfter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.notAfter = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("vxwtsyfdkuchxppk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListIntegrationAccountCallbackUrlPlainArgs =
        ListIntegrationAccountCallbackUrlPlainArgs(
            integrationAccountName = integrationAccountName ?: throw
                PulumiNullFieldException("integrationAccountName"),
            keyType = keyType,
            notAfter = notAfter,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
