@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.ListWorkflowRunActionRepetitionExpressionTracesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property actionName The workflow action name.
 * @property repetitionName The workflow repetition.
 * @property resourceGroupName The resource group name.
 * @property runName The workflow run name.
 * @property workflowName The workflow name.
 */
public data class ListWorkflowRunActionRepetitionExpressionTracesPlainArgs(
    public val actionName: String,
    public val repetitionName: String,
    public val resourceGroupName: String,
    public val runName: String,
    public val workflowName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.logic.inputs.ListWorkflowRunActionRepetitionExpressionTracesPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.ListWorkflowRunActionRepetitionExpressionTracesPlainArgs =
        com.pulumi.azurenative.logic.inputs.ListWorkflowRunActionRepetitionExpressionTracesPlainArgs.builder()
            .actionName(actionName.let({ args0 -> args0 }))
            .repetitionName(repetitionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .runName(runName.let({ args0 -> args0 }))
            .workflowName(workflowName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListWorkflowRunActionRepetitionExpressionTracesPlainArgs].
 */
@PulumiTagMarker
public class ListWorkflowRunActionRepetitionExpressionTracesPlainArgsBuilder internal constructor() {
    private var actionName: String? = null

    private var repetitionName: String? = null

    private var resourceGroupName: String? = null

    private var runName: String? = null

    private var workflowName: String? = null

    /**
     * @param value The workflow action name.
     */
    @JvmName("ylxjpkyxkdbwuxty")
    public suspend fun actionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.actionName = mapped
    }

    /**
     * @param value The workflow repetition.
     */
    @JvmName("uyprgxsnncbstfkn")
    public suspend fun repetitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.repetitionName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("yddjgfnkhirjnuew")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The workflow run name.
     */
    @JvmName("vibbwhxoerclefir")
    public suspend fun runName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.runName = mapped
    }

    /**
     * @param value The workflow name.
     */
    @JvmName("wokuytmpxqtcgqyj")
    public suspend fun workflowName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workflowName = mapped
    }

    internal fun build(): ListWorkflowRunActionRepetitionExpressionTracesPlainArgs =
        ListWorkflowRunActionRepetitionExpressionTracesPlainArgs(
            actionName = actionName ?: throw PulumiNullFieldException("actionName"),
            repetitionName = repetitionName ?: throw PulumiNullFieldException("repetitionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            runName = runName ?: throw PulumiNullFieldException("runName"),
            workflowName = workflowName ?: throw PulumiNullFieldException("workflowName"),
        )
}
