@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.RecurrenceScheduleOccurrenceArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.DayOfWeek
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The recurrence schedule occurrence.
 * @property day The day of the week.
 * @property occurrence The occurrence.
 */
public data class RecurrenceScheduleOccurrenceArgs(
    public val day: Output<DayOfWeek>? = null,
    public val occurrence: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.RecurrenceScheduleOccurrenceArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.RecurrenceScheduleOccurrenceArgs =
        com.pulumi.azurenative.logic.inputs.RecurrenceScheduleOccurrenceArgs.builder()
            .day(day?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .occurrence(occurrence?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecurrenceScheduleOccurrenceArgs].
 */
@PulumiTagMarker
public class RecurrenceScheduleOccurrenceArgsBuilder internal constructor() {
    private var day: Output<DayOfWeek>? = null

    private var occurrence: Output<Int>? = null

    /**
     * @param value The day of the week.
     */
    @JvmName("ewinmxsqoruynmxr")
    public suspend fun day(`value`: Output<DayOfWeek>) {
        this.day = value
    }

    /**
     * @param value The occurrence.
     */
    @JvmName("qluqtfqgavdxgksv")
    public suspend fun occurrence(`value`: Output<Int>) {
        this.occurrence = value
    }

    /**
     * @param value The day of the week.
     */
    @JvmName("ysswfrgfhxeqlgcr")
    public suspend fun day(`value`: DayOfWeek?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.day = mapped
    }

    /**
     * @param value The occurrence.
     */
    @JvmName("mkhfcqqppdxfrfhp")
    public suspend fun occurrence(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.occurrence = mapped
    }

    internal fun build(): RecurrenceScheduleOccurrenceArgs = RecurrenceScheduleOccurrenceArgs(
        day = day,
        occurrence = occurrence,
    )
}
