@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.RosettaNetPipActivityBehaviorArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.RosettaNetActionType
import com.pulumi.azurenative.logic.kotlin.enums.RosettaNetPipConfidentialityScope
import com.pulumi.azurenative.logic.kotlin.enums.RosettaNetResponseType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The integration account RosettaNet ProcessConfiguration activity behavior.
 * @property actionType The value indicating whether the RosettaNet PIP is used for a single action.
 * @property isAuthorizationRequired The value indicating whether authorization is required.
 * @property isSecuredTransportRequired The value indicating whether secured transport is required.
 * @property nonRepudiationOfOriginAndContent The value indicating whether non-repudiation is for origin and content.
 * @property persistentConfidentialityScope The persistent confidentiality encryption scope.
 * @property responseType The value indicating whether the RosettaNet PIP communication is synchronous.
 * @property retryCount The value indicating retry count.
 * @property timeToPerformInSeconds The time to perform in seconds.
 */
public data class RosettaNetPipActivityBehaviorArgs(
    public val actionType: Output<RosettaNetActionType>,
    public val isAuthorizationRequired: Output<Boolean>,
    public val isSecuredTransportRequired: Output<Boolean>,
    public val nonRepudiationOfOriginAndContent: Output<Boolean>,
    public val persistentConfidentialityScope: Output<RosettaNetPipConfidentialityScope>,
    public val responseType: Output<RosettaNetResponseType>,
    public val retryCount: Output<Int>,
    public val timeToPerformInSeconds: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.RosettaNetPipActivityBehaviorArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.RosettaNetPipActivityBehaviorArgs =
        com.pulumi.azurenative.logic.inputs.RosettaNetPipActivityBehaviorArgs.builder()
            .actionType(actionType.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .isAuthorizationRequired(isAuthorizationRequired.applyValue({ args0 -> args0 }))
            .isSecuredTransportRequired(isSecuredTransportRequired.applyValue({ args0 -> args0 }))
            .nonRepudiationOfOriginAndContent(nonRepudiationOfOriginAndContent.applyValue({ args0 -> args0 }))
            .persistentConfidentialityScope(
                persistentConfidentialityScope.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .responseType(responseType.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .retryCount(retryCount.applyValue({ args0 -> args0 }))
            .timeToPerformInSeconds(timeToPerformInSeconds.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RosettaNetPipActivityBehaviorArgs].
 */
@PulumiTagMarker
public class RosettaNetPipActivityBehaviorArgsBuilder internal constructor() {
    private var actionType: Output<RosettaNetActionType>? = null

    private var isAuthorizationRequired: Output<Boolean>? = null

    private var isSecuredTransportRequired: Output<Boolean>? = null

    private var nonRepudiationOfOriginAndContent: Output<Boolean>? = null

    private var persistentConfidentialityScope: Output<RosettaNetPipConfidentialityScope>? = null

    private var responseType: Output<RosettaNetResponseType>? = null

    private var retryCount: Output<Int>? = null

    private var timeToPerformInSeconds: Output<Int>? = null

    /**
     * @param value The value indicating whether the RosettaNet PIP is used for a single action.
     */
    @JvmName("mjdkptaqekjpdgan")
    public suspend fun actionType(`value`: Output<RosettaNetActionType>) {
        this.actionType = value
    }

    /**
     * @param value The value indicating whether authorization is required.
     */
    @JvmName("uegibrdtjywwkyge")
    public suspend fun isAuthorizationRequired(`value`: Output<Boolean>) {
        this.isAuthorizationRequired = value
    }

    /**
     * @param value The value indicating whether secured transport is required.
     */
    @JvmName("iswjimniqjunlmbx")
    public suspend fun isSecuredTransportRequired(`value`: Output<Boolean>) {
        this.isSecuredTransportRequired = value
    }

    /**
     * @param value The value indicating whether non-repudiation is for origin and content.
     */
    @JvmName("omrfoqvjieygblqh")
    public suspend fun nonRepudiationOfOriginAndContent(`value`: Output<Boolean>) {
        this.nonRepudiationOfOriginAndContent = value
    }

    /**
     * @param value The persistent confidentiality encryption scope.
     */
    @JvmName("kwndythrjridqbxi")
    public suspend fun persistentConfidentialityScope(`value`: Output<RosettaNetPipConfidentialityScope>) {
        this.persistentConfidentialityScope = value
    }

    /**
     * @param value The value indicating whether the RosettaNet PIP communication is synchronous.
     */
    @JvmName("rminhslkbubynimx")
    public suspend fun responseType(`value`: Output<RosettaNetResponseType>) {
        this.responseType = value
    }

    /**
     * @param value The value indicating retry count.
     */
    @JvmName("udlmyehviowdfrno")
    public suspend fun retryCount(`value`: Output<Int>) {
        this.retryCount = value
    }

    /**
     * @param value The time to perform in seconds.
     */
    @JvmName("jmgfqpcbewdqrdel")
    public suspend fun timeToPerformInSeconds(`value`: Output<Int>) {
        this.timeToPerformInSeconds = value
    }

    /**
     * @param value The value indicating whether the RosettaNet PIP is used for a single action.
     */
    @JvmName("xycssgruwlkfdcby")
    public suspend fun actionType(`value`: RosettaNetActionType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    /**
     * @param value The value indicating whether authorization is required.
     */
    @JvmName("hkudpwfcjdougubb")
    public suspend fun isAuthorizationRequired(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isAuthorizationRequired = mapped
    }

    /**
     * @param value The value indicating whether secured transport is required.
     */
    @JvmName("iofhcpjqhhcymgss")
    public suspend fun isSecuredTransportRequired(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isSecuredTransportRequired = mapped
    }

    /**
     * @param value The value indicating whether non-repudiation is for origin and content.
     */
    @JvmName("yovnangbowtathal")
    public suspend fun nonRepudiationOfOriginAndContent(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nonRepudiationOfOriginAndContent = mapped
    }

    /**
     * @param value The persistent confidentiality encryption scope.
     */
    @JvmName("eskqyowvsuoetwmr")
    public suspend fun persistentConfidentialityScope(`value`: RosettaNetPipConfidentialityScope) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.persistentConfidentialityScope = mapped
    }

    /**
     * @param value The value indicating whether the RosettaNet PIP communication is synchronous.
     */
    @JvmName("igwrvciumauibmyy")
    public suspend fun responseType(`value`: RosettaNetResponseType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseType = mapped
    }

    /**
     * @param value The value indicating retry count.
     */
    @JvmName("caoppoornqmocmpf")
    public suspend fun retryCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retryCount = mapped
    }

    /**
     * @param value The time to perform in seconds.
     */
    @JvmName("lgvbqrntjxohyyno")
    public suspend fun timeToPerformInSeconds(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeToPerformInSeconds = mapped
    }

    internal fun build(): RosettaNetPipActivityBehaviorArgs = RosettaNetPipActivityBehaviorArgs(
        actionType = actionType ?: throw PulumiNullFieldException("actionType"),
        isAuthorizationRequired = isAuthorizationRequired ?: throw
            PulumiNullFieldException("isAuthorizationRequired"),
        isSecuredTransportRequired = isSecuredTransportRequired ?: throw
            PulumiNullFieldException("isSecuredTransportRequired"),
        nonRepudiationOfOriginAndContent = nonRepudiationOfOriginAndContent ?: throw
            PulumiNullFieldException("nonRepudiationOfOriginAndContent"),
        persistentConfidentialityScope = persistentConfidentialityScope ?: throw
            PulumiNullFieldException("persistentConfidentialityScope"),
        responseType = responseType ?: throw PulumiNullFieldException("responseType"),
        retryCount = retryCount ?: throw PulumiNullFieldException("retryCount"),
        timeToPerformInSeconds = timeToPerformInSeconds ?: throw
            PulumiNullFieldException("timeToPerformInSeconds"),
    )
}
