@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.RosettaNetPipActivitySettingsArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.RosettaNetPipActivityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The integration account RosettaNet ProcessConfiguration activity settings.
 * @property acknowledgmentOfReceiptSettings The RosettaNet ProcessConfiguration acknowledgement settings.
 * @property activityBehavior The RosettaNet ProcessConfiguration activity behavior.
 * @property activityType The RosettaNet ProcessConfiguration activity type.
 */
public data class RosettaNetPipActivitySettingsArgs(
    public val acknowledgmentOfReceiptSettings: Output<RosettaNetPipAcknowledgmentOfReceiptSettingsArgs>,
    public val activityBehavior: Output<RosettaNetPipActivityBehaviorArgs>,
    public val activityType: Output<RosettaNetPipActivityType>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.RosettaNetPipActivitySettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.RosettaNetPipActivitySettingsArgs =
        com.pulumi.azurenative.logic.inputs.RosettaNetPipActivitySettingsArgs.builder()
            .acknowledgmentOfReceiptSettings(
                acknowledgmentOfReceiptSettings.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .activityBehavior(activityBehavior.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .activityType(activityType.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RosettaNetPipActivitySettingsArgs].
 */
@PulumiTagMarker
public class RosettaNetPipActivitySettingsArgsBuilder internal constructor() {
    private var acknowledgmentOfReceiptSettings:
        Output<RosettaNetPipAcknowledgmentOfReceiptSettingsArgs>? = null

    private var activityBehavior: Output<RosettaNetPipActivityBehaviorArgs>? = null

    private var activityType: Output<RosettaNetPipActivityType>? = null

    /**
     * @param value The RosettaNet ProcessConfiguration acknowledgement settings.
     */
    @JvmName("cnomdtptmopfsrnr")
    public suspend fun acknowledgmentOfReceiptSettings(`value`: Output<RosettaNetPipAcknowledgmentOfReceiptSettingsArgs>) {
        this.acknowledgmentOfReceiptSettings = value
    }

    /**
     * @param value The RosettaNet ProcessConfiguration activity behavior.
     */
    @JvmName("ydtwhdttqyeoiymh")
    public suspend fun activityBehavior(`value`: Output<RosettaNetPipActivityBehaviorArgs>) {
        this.activityBehavior = value
    }

    /**
     * @param value The RosettaNet ProcessConfiguration activity type.
     */
    @JvmName("ndhvipgeiigpggcp")
    public suspend fun activityType(`value`: Output<RosettaNetPipActivityType>) {
        this.activityType = value
    }

    /**
     * @param value The RosettaNet ProcessConfiguration acknowledgement settings.
     */
    @JvmName("pyufdhiwhcjqckjt")
    public suspend fun acknowledgmentOfReceiptSettings(`value`: RosettaNetPipAcknowledgmentOfReceiptSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acknowledgmentOfReceiptSettings = mapped
    }

    /**
     * @param argument The RosettaNet ProcessConfiguration acknowledgement settings.
     */
    @JvmName("iywxodjpqsyskrgu")
    public suspend fun acknowledgmentOfReceiptSettings(argument: suspend RosettaNetPipAcknowledgmentOfReceiptSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = RosettaNetPipAcknowledgmentOfReceiptSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.acknowledgmentOfReceiptSettings = mapped
    }

    /**
     * @param value The RosettaNet ProcessConfiguration activity behavior.
     */
    @JvmName("rqnmhdwdxugfgmoh")
    public suspend fun activityBehavior(`value`: RosettaNetPipActivityBehaviorArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activityBehavior = mapped
    }

    /**
     * @param argument The RosettaNet ProcessConfiguration activity behavior.
     */
    @JvmName("abewiwueqjjcecjl")
    public suspend fun activityBehavior(argument: suspend RosettaNetPipActivityBehaviorArgsBuilder.() -> Unit) {
        val toBeMapped = RosettaNetPipActivityBehaviorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.activityBehavior = mapped
    }

    /**
     * @param value The RosettaNet ProcessConfiguration activity type.
     */
    @JvmName("ruuyxrwjbiuwgspp")
    public suspend fun activityType(`value`: RosettaNetPipActivityType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activityType = mapped
    }

    internal fun build(): RosettaNetPipActivitySettingsArgs = RosettaNetPipActivitySettingsArgs(
        acknowledgmentOfReceiptSettings = acknowledgmentOfReceiptSettings ?: throw
            PulumiNullFieldException("acknowledgmentOfReceiptSettings"),
        activityBehavior = activityBehavior ?: throw PulumiNullFieldException("activityBehavior"),
        activityType = activityType ?: throw PulumiNullFieldException("activityType"),
    )
}
